/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ContinueUpdateRollbackRequestMarshaller
implements Marshaller<Request<ContinueUpdateRollbackRequest>, ContinueUpdateRollbackRequest> {
    public Request<ContinueUpdateRollbackRequest> marshall(ContinueUpdateRollbackRequest continueUpdateRollbackRequest) {
        if (continueUpdateRollbackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)continueUpdateRollbackRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ContinueUpdateRollback");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (continueUpdateRollbackRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)continueUpdateRollbackRequest.getStackName()));
        }
        if (continueUpdateRollbackRequest.getRoleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)continueUpdateRollbackRequest.getRoleARN()));
        }
        if (continueUpdateRollbackRequest.getResourcesToSkip().isEmpty() && !((SdkInternalList)continueUpdateRollbackRequest.getResourcesToSkip()).isAutoConstruct()) {
            request.addParameter("ResourcesToSkip", "");
        }
        if (!continueUpdateRollbackRequest.getResourcesToSkip().isEmpty() || !((SdkInternalList)continueUpdateRollbackRequest.getResourcesToSkip()).isAutoConstruct()) {
            SdkInternalList resourcesToSkipList = (SdkInternalList)continueUpdateRollbackRequest.getResourcesToSkip();
            int resourcesToSkipListIndex = 1;
            for (String resourcesToSkipListValue : resourcesToSkipList) {
                if (resourcesToSkipListValue != null) {
                    request.addParameter("ResourcesToSkip.member." + resourcesToSkipListIndex, StringUtils.fromString((String)resourcesToSkipListValue));
                }
                ++resourcesToSkipListIndex;
            }
        }
        if (continueUpdateRollbackRequest.getClientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)continueUpdateRollbackRequest.getClientRequestToken()));
        }
        return request;
    }
}

