/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.services.cloudsearchv2.model.TextArrayOptions;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class TextArrayOptionsStaxUnmarshaller
implements Unmarshaller<TextArrayOptions, StaxUnmarshallerContext> {
    private static TextArrayOptionsStaxUnmarshaller instance;

    public TextArrayOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        TextArrayOptions textArrayOptions = new TextArrayOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return textArrayOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DefaultValue", targetDepth)) {
                    textArrayOptions.setDefaultValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceFields", targetDepth)) {
                    textArrayOptions.setSourceFields(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReturnEnabled", targetDepth)) {
                    textArrayOptions.setReturnEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HighlightEnabled", targetDepth)) {
                    textArrayOptions.setHighlightEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AnalysisScheme", targetDepth)) continue;
                textArrayOptions.setAnalysisScheme(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return textArrayOptions;
    }

    public static TextArrayOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TextArrayOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

