/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DocumentSuggesterOptions;
import com.amazonaws.services.cloudsearchv2.model.Suggester;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DefineSuggesterRequestMarshaller
implements Marshaller<Request<DefineSuggesterRequest>, DefineSuggesterRequest> {
    public Request<DefineSuggesterRequest> marshall(DefineSuggesterRequest defineSuggesterRequest) {
        Suggester suggester;
        if (defineSuggesterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)defineSuggesterRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineSuggester");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineSuggesterRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)defineSuggesterRequest.getDomainName()));
        }
        if ((suggester = defineSuggesterRequest.getSuggester()) != null) {
            DocumentSuggesterOptions documentSuggesterOptions;
            if (suggester.getSuggesterName() != null) {
                request.addParameter("Suggester.SuggesterName", StringUtils.fromString((String)suggester.getSuggesterName()));
            }
            if ((documentSuggesterOptions = suggester.getDocumentSuggesterOptions()) != null) {
                if (documentSuggesterOptions.getSourceField() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.SourceField", StringUtils.fromString((String)documentSuggesterOptions.getSourceField()));
                }
                if (documentSuggesterOptions.getFuzzyMatching() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.FuzzyMatching", StringUtils.fromString((String)documentSuggesterOptions.getFuzzyMatching()));
                }
                if (documentSuggesterOptions.getSortExpression() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.SortExpression", StringUtils.fromString((String)documentSuggesterOptions.getSortExpression()));
                }
            }
        }
        return request;
    }
}

