/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeartifact.model.RepositoryExternalConnectionInfo;
import com.amazonaws.services.codeartifact.model.UpstreamRepositoryInfo;
import com.amazonaws.services.codeartifact.model.transform.RepositoryDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RepositoryDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String administratorAccount;
    private String domainName;
    private String domainOwner;
    private String arn;
    private String description;
    private List<UpstreamRepositoryInfo> upstreams;
    private List<RepositoryExternalConnectionInfo> externalConnections;
    private Date createdTime;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RepositoryDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public void setAdministratorAccount(String administratorAccount) {
        this.administratorAccount = administratorAccount;
    }

    public String getAdministratorAccount() {
        return this.administratorAccount;
    }

    public RepositoryDescription withAdministratorAccount(String administratorAccount) {
        this.setAdministratorAccount(administratorAccount);
        return this;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public RepositoryDescription withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setDomainOwner(String domainOwner) {
        this.domainOwner = domainOwner;
    }

    public String getDomainOwner() {
        return this.domainOwner;
    }

    public RepositoryDescription withDomainOwner(String domainOwner) {
        this.setDomainOwner(domainOwner);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public RepositoryDescription withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RepositoryDescription withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<UpstreamRepositoryInfo> getUpstreams() {
        return this.upstreams;
    }

    public void setUpstreams(Collection<UpstreamRepositoryInfo> upstreams) {
        if (upstreams == null) {
            this.upstreams = null;
            return;
        }
        this.upstreams = new ArrayList<UpstreamRepositoryInfo>(upstreams);
    }

    public RepositoryDescription withUpstreams(UpstreamRepositoryInfo ... upstreams) {
        if (this.upstreams == null) {
            this.setUpstreams(new ArrayList<UpstreamRepositoryInfo>(upstreams.length));
        }
        for (UpstreamRepositoryInfo ele : upstreams) {
            this.upstreams.add(ele);
        }
        return this;
    }

    public RepositoryDescription withUpstreams(Collection<UpstreamRepositoryInfo> upstreams) {
        this.setUpstreams(upstreams);
        return this;
    }

    public List<RepositoryExternalConnectionInfo> getExternalConnections() {
        return this.externalConnections;
    }

    public void setExternalConnections(Collection<RepositoryExternalConnectionInfo> externalConnections) {
        if (externalConnections == null) {
            this.externalConnections = null;
            return;
        }
        this.externalConnections = new ArrayList<RepositoryExternalConnectionInfo>(externalConnections);
    }

    public RepositoryDescription withExternalConnections(RepositoryExternalConnectionInfo ... externalConnections) {
        if (this.externalConnections == null) {
            this.setExternalConnections(new ArrayList<RepositoryExternalConnectionInfo>(externalConnections.length));
        }
        for (RepositoryExternalConnectionInfo ele : externalConnections) {
            this.externalConnections.add(ele);
        }
        return this;
    }

    public RepositoryDescription withExternalConnections(Collection<RepositoryExternalConnectionInfo> externalConnections) {
        this.setExternalConnections(externalConnections);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public RepositoryDescription withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAdministratorAccount() != null) {
            sb.append("AdministratorAccount: ").append(this.getAdministratorAccount()).append(",");
        }
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getDomainOwner() != null) {
            sb.append("DomainOwner: ").append(this.getDomainOwner()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getUpstreams() != null) {
            sb.append("Upstreams: ").append(this.getUpstreams()).append(",");
        }
        if (this.getExternalConnections() != null) {
            sb.append("ExternalConnections: ").append(this.getExternalConnections()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryDescription)) {
            return false;
        }
        RepositoryDescription other = (RepositoryDescription)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAdministratorAccount() == null ^ this.getAdministratorAccount() == null) {
            return false;
        }
        if (other.getAdministratorAccount() != null && !other.getAdministratorAccount().equals(this.getAdministratorAccount())) {
            return false;
        }
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getDomainOwner() == null ^ this.getDomainOwner() == null) {
            return false;
        }
        if (other.getDomainOwner() != null && !other.getDomainOwner().equals(this.getDomainOwner())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getUpstreams() == null ^ this.getUpstreams() == null) {
            return false;
        }
        if (other.getUpstreams() != null && !other.getUpstreams().equals(this.getUpstreams())) {
            return false;
        }
        if (other.getExternalConnections() == null ^ this.getExternalConnections() == null) {
            return false;
        }
        if (other.getExternalConnections() != null && !other.getExternalConnections().equals(this.getExternalConnections())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        return other.getCreatedTime() == null || other.getCreatedTime().equals(this.getCreatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAdministratorAccount() == null ? 0 : this.getAdministratorAccount().hashCode());
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getDomainOwner() == null ? 0 : this.getDomainOwner().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getUpstreams() == null ? 0 : this.getUpstreams().hashCode());
        hashCode = 31 * hashCode + (this.getExternalConnections() == null ? 0 : this.getExternalConnections().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        return hashCode;
    }

    public RepositoryDescription clone() {
        try {
            return (RepositoryDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

