/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codestarconnections.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information, such as repository, branch, provider, and resource names for a specific sync configuration.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codestar-connections-2019-12-01/SyncConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SyncConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The branch associated with a specific sync configuration.
     * </p>
     */
    private String branch;
    /**
     * <p>
     * The file path to the configuration file associated with a specific sync configuration. The path should point to
     * an actual file in the sync configurations linked repository.
     * </p>
     */
    private String configFile;
    /**
     * <p>
     * The owner ID for the repository associated with a specific sync configuration, such as the owner ID in GitHub.
     * </p>
     */
    private String ownerId;
    /**
     * <p>
     * The connection provider type associated with a specific sync configuration, such as GitHub.
     * </p>
     */
    private String providerType;
    /**
     * <p>
     * The ID of the repository link associated with a specific sync configuration.
     * </p>
     */
    private String repositoryLinkId;
    /**
     * <p>
     * The name of the repository associated with a specific sync configuration.
     * </p>
     */
    private String repositoryName;
    /**
     * <p>
     * The name of the connection resource associated with a specific sync configuration.
     * </p>
     */
    private String resourceName;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     * </p>
     */
    private String roleArn;
    /**
     * <p>
     * The type of sync for a specific sync configuration.
     * </p>
     */
    private String syncType;
    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     */
    private String publishDeploymentStatus;
    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     */
    private String triggerResourceUpdateOn;

    /**
     * <p>
     * The branch associated with a specific sync configuration.
     * </p>
     * 
     * @param branch
     *        The branch associated with a specific sync configuration.
     */

    public void setBranch(String branch) {
        this.branch = branch;
    }

    /**
     * <p>
     * The branch associated with a specific sync configuration.
     * </p>
     * 
     * @return The branch associated with a specific sync configuration.
     */

    public String getBranch() {
        return this.branch;
    }

    /**
     * <p>
     * The branch associated with a specific sync configuration.
     * </p>
     * 
     * @param branch
     *        The branch associated with a specific sync configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SyncConfiguration withBranch(String branch) {
        setBranch(branch);
        return this;
    }

    /**
     * <p>
     * The file path to the configuration file associated with a specific sync configuration. The path should point to
     * an actual file in the sync configurations linked repository.
     * </p>
     * 
     * @param configFile
     *        The file path to the configuration file associated with a specific sync configuration. The path should
     *        point to an actual file in the sync configurations linked repository.
     */

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    /**
     * <p>
     * The file path to the configuration file associated with a specific sync configuration. The path should point to
     * an actual file in the sync configurations linked repository.
     * </p>
     * 
     * @return The file path to the configuration file associated with a specific sync configuration. The path should
     *         point to an actual file in the sync configurations linked repository.
     */

    public String getConfigFile() {
        return this.configFile;
    }

    /**
     * <p>
     * The file path to the configuration file associated with a specific sync configuration. The path should point to
     * an actual file in the sync configurations linked repository.
     * </p>
     * 
     * @param configFile
     *        The file path to the configuration file associated with a specific sync configuration. The path should
     *        point to an actual file in the sync configurations linked repository.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SyncConfiguration withConfigFile(String configFile) {
        setConfigFile(configFile);
        return this;
    }

    /**
     * <p>
     * The owner ID for the repository associated with a specific sync configuration, such as the owner ID in GitHub.
     * </p>
     * 
     * @param ownerId
     *        The owner ID for the repository associated with a specific sync configuration, such as the owner ID in
     *        GitHub.
     */

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    /**
     * <p>
     * The owner ID for the repository associated with a specific sync configuration, such as the owner ID in GitHub.
     * </p>
     * 
     * @return The owner ID for the repository associated with a specific sync configuration, such as the owner ID in
     *         GitHub.
     */

    public String getOwnerId() {
        return this.ownerId;
    }

    /**
     * <p>
     * The owner ID for the repository associated with a specific sync configuration, such as the owner ID in GitHub.
     * </p>
     * 
     * @param ownerId
     *        The owner ID for the repository associated with a specific sync configuration, such as the owner ID in
     *        GitHub.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SyncConfiguration withOwnerId(String ownerId) {
        setOwnerId(ownerId);
        return this;
    }

    /**
     * <p>
     * The connection provider type associated with a specific sync configuration, such as GitHub.
     * </p>
     * 
     * @param providerType
     *        The connection provider type associated with a specific sync configuration, such as GitHub.
     * @see ProviderType
     */

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    /**
     * <p>
     * The connection provider type associated with a specific sync configuration, such as GitHub.
     * </p>
     * 
     * @return The connection provider type associated with a specific sync configuration, such as GitHub.
     * @see ProviderType
     */

    public String getProviderType() {
        return this.providerType;
    }

    /**
     * <p>
     * The connection provider type associated with a specific sync configuration, such as GitHub.
     * </p>
     * 
     * @param providerType
     *        The connection provider type associated with a specific sync configuration, such as GitHub.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ProviderType
     */

    public SyncConfiguration withProviderType(String providerType) {
        setProviderType(providerType);
        return this;
    }

    /**
     * <p>
     * The connection provider type associated with a specific sync configuration, such as GitHub.
     * </p>
     * 
     * @param providerType
     *        The connection provider type associated with a specific sync configuration, such as GitHub.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ProviderType
     */

    public SyncConfiguration withProviderType(ProviderType providerType) {
        this.providerType = providerType.toString();
        return this;
    }

    /**
     * <p>
     * The ID of the repository link associated with a specific sync configuration.
     * </p>
     * 
     * @param repositoryLinkId
     *        The ID of the repository link associated with a specific sync configuration.
     */

    public void setRepositoryLinkId(String repositoryLinkId) {
        this.repositoryLinkId = repositoryLinkId;
    }

    /**
     * <p>
     * The ID of the repository link associated with a specific sync configuration.
     * </p>
     * 
     * @return The ID of the repository link associated with a specific sync configuration.
     */

    public String getRepositoryLinkId() {
        return this.repositoryLinkId;
    }

    /**
     * <p>
     * The ID of the repository link associated with a specific sync configuration.
     * </p>
     * 
     * @param repositoryLinkId
     *        The ID of the repository link associated with a specific sync configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SyncConfiguration withRepositoryLinkId(String repositoryLinkId) {
        setRepositoryLinkId(repositoryLinkId);
        return this;
    }

    /**
     * <p>
     * The name of the repository associated with a specific sync configuration.
     * </p>
     * 
     * @param repositoryName
     *        The name of the repository associated with a specific sync configuration.
     */

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    /**
     * <p>
     * The name of the repository associated with a specific sync configuration.
     * </p>
     * 
     * @return The name of the repository associated with a specific sync configuration.
     */

    public String getRepositoryName() {
        return this.repositoryName;
    }

    /**
     * <p>
     * The name of the repository associated with a specific sync configuration.
     * </p>
     * 
     * @param repositoryName
     *        The name of the repository associated with a specific sync configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SyncConfiguration withRepositoryName(String repositoryName) {
        setRepositoryName(repositoryName);
        return this;
    }

    /**
     * <p>
     * The name of the connection resource associated with a specific sync configuration.
     * </p>
     * 
     * @param resourceName
     *        The name of the connection resource associated with a specific sync configuration.
     */

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    /**
     * <p>
     * The name of the connection resource associated with a specific sync configuration.
     * </p>
     * 
     * @return The name of the connection resource associated with a specific sync configuration.
     */

    public String getResourceName() {
        return this.resourceName;
    }

    /**
     * <p>
     * The name of the connection resource associated with a specific sync configuration.
     * </p>
     * 
     * @param resourceName
     *        The name of the connection resource associated with a specific sync configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SyncConfiguration withResourceName(String resourceName) {
        setResourceName(resourceName);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     * </p>
     * 
     * @param roleArn
     *        The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     */

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     */

    public String getRoleArn() {
        return this.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     * </p>
     * 
     * @param roleArn
     *        The Amazon Resource Name (ARN) of the IAM role associated with a specific sync configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SyncConfiguration withRoleArn(String roleArn) {
        setRoleArn(roleArn);
        return this;
    }

    /**
     * <p>
     * The type of sync for a specific sync configuration.
     * </p>
     * 
     * @param syncType
     *        The type of sync for a specific sync configuration.
     * @see SyncConfigurationType
     */

    public void setSyncType(String syncType) {
        this.syncType = syncType;
    }

    /**
     * <p>
     * The type of sync for a specific sync configuration.
     * </p>
     * 
     * @return The type of sync for a specific sync configuration.
     * @see SyncConfigurationType
     */

    public String getSyncType() {
        return this.syncType;
    }

    /**
     * <p>
     * The type of sync for a specific sync configuration.
     * </p>
     * 
     * @param syncType
     *        The type of sync for a specific sync configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SyncConfigurationType
     */

    public SyncConfiguration withSyncType(String syncType) {
        setSyncType(syncType);
        return this;
    }

    /**
     * <p>
     * The type of sync for a specific sync configuration.
     * </p>
     * 
     * @param syncType
     *        The type of sync for a specific sync configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SyncConfigurationType
     */

    public SyncConfiguration withSyncType(SyncConfigurationType syncType) {
        this.syncType = syncType.toString();
        return this;
    }

    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     * 
     * @param publishDeploymentStatus
     *        Whether to enable or disable publishing of deployment status to source providers.
     * @see PublishDeploymentStatus
     */

    public void setPublishDeploymentStatus(String publishDeploymentStatus) {
        this.publishDeploymentStatus = publishDeploymentStatus;
    }

    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     * 
     * @return Whether to enable or disable publishing of deployment status to source providers.
     * @see PublishDeploymentStatus
     */

    public String getPublishDeploymentStatus() {
        return this.publishDeploymentStatus;
    }

    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     * 
     * @param publishDeploymentStatus
     *        Whether to enable or disable publishing of deployment status to source providers.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PublishDeploymentStatus
     */

    public SyncConfiguration withPublishDeploymentStatus(String publishDeploymentStatus) {
        setPublishDeploymentStatus(publishDeploymentStatus);
        return this;
    }

    /**
     * <p>
     * Whether to enable or disable publishing of deployment status to source providers.
     * </p>
     * 
     * @param publishDeploymentStatus
     *        Whether to enable or disable publishing of deployment status to source providers.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PublishDeploymentStatus
     */

    public SyncConfiguration withPublishDeploymentStatus(PublishDeploymentStatus publishDeploymentStatus) {
        this.publishDeploymentStatus = publishDeploymentStatus.toString();
        return this;
    }

    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     * 
     * @param triggerResourceUpdateOn
     *        When to trigger Git sync to begin the stack update.
     * @see TriggerResourceUpdateOn
     */

    public void setTriggerResourceUpdateOn(String triggerResourceUpdateOn) {
        this.triggerResourceUpdateOn = triggerResourceUpdateOn;
    }

    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     * 
     * @return When to trigger Git sync to begin the stack update.
     * @see TriggerResourceUpdateOn
     */

    public String getTriggerResourceUpdateOn() {
        return this.triggerResourceUpdateOn;
    }

    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     * 
     * @param triggerResourceUpdateOn
     *        When to trigger Git sync to begin the stack update.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TriggerResourceUpdateOn
     */

    public SyncConfiguration withTriggerResourceUpdateOn(String triggerResourceUpdateOn) {
        setTriggerResourceUpdateOn(triggerResourceUpdateOn);
        return this;
    }

    /**
     * <p>
     * When to trigger Git sync to begin the stack update.
     * </p>
     * 
     * @param triggerResourceUpdateOn
     *        When to trigger Git sync to begin the stack update.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TriggerResourceUpdateOn
     */

    public SyncConfiguration withTriggerResourceUpdateOn(TriggerResourceUpdateOn triggerResourceUpdateOn) {
        this.triggerResourceUpdateOn = triggerResourceUpdateOn.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBranch() != null)
            sb.append("Branch: ").append(getBranch()).append(",");
        if (getConfigFile() != null)
            sb.append("ConfigFile: ").append(getConfigFile()).append(",");
        if (getOwnerId() != null)
            sb.append("OwnerId: ").append(getOwnerId()).append(",");
        if (getProviderType() != null)
            sb.append("ProviderType: ").append(getProviderType()).append(",");
        if (getRepositoryLinkId() != null)
            sb.append("RepositoryLinkId: ").append(getRepositoryLinkId()).append(",");
        if (getRepositoryName() != null)
            sb.append("RepositoryName: ").append(getRepositoryName()).append(",");
        if (getResourceName() != null)
            sb.append("ResourceName: ").append(getResourceName()).append(",");
        if (getRoleArn() != null)
            sb.append("RoleArn: ").append(getRoleArn()).append(",");
        if (getSyncType() != null)
            sb.append("SyncType: ").append(getSyncType()).append(",");
        if (getPublishDeploymentStatus() != null)
            sb.append("PublishDeploymentStatus: ").append(getPublishDeploymentStatus()).append(",");
        if (getTriggerResourceUpdateOn() != null)
            sb.append("TriggerResourceUpdateOn: ").append(getTriggerResourceUpdateOn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SyncConfiguration == false)
            return false;
        SyncConfiguration other = (SyncConfiguration) obj;
        if (other.getBranch() == null ^ this.getBranch() == null)
            return false;
        if (other.getBranch() != null && other.getBranch().equals(this.getBranch()) == false)
            return false;
        if (other.getConfigFile() == null ^ this.getConfigFile() == null)
            return false;
        if (other.getConfigFile() != null && other.getConfigFile().equals(this.getConfigFile()) == false)
            return false;
        if (other.getOwnerId() == null ^ this.getOwnerId() == null)
            return false;
        if (other.getOwnerId() != null && other.getOwnerId().equals(this.getOwnerId()) == false)
            return false;
        if (other.getProviderType() == null ^ this.getProviderType() == null)
            return false;
        if (other.getProviderType() != null && other.getProviderType().equals(this.getProviderType()) == false)
            return false;
        if (other.getRepositoryLinkId() == null ^ this.getRepositoryLinkId() == null)
            return false;
        if (other.getRepositoryLinkId() != null && other.getRepositoryLinkId().equals(this.getRepositoryLinkId()) == false)
            return false;
        if (other.getRepositoryName() == null ^ this.getRepositoryName() == null)
            return false;
        if (other.getRepositoryName() != null && other.getRepositoryName().equals(this.getRepositoryName()) == false)
            return false;
        if (other.getResourceName() == null ^ this.getResourceName() == null)
            return false;
        if (other.getResourceName() != null && other.getResourceName().equals(this.getResourceName()) == false)
            return false;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null)
            return false;
        if (other.getRoleArn() != null && other.getRoleArn().equals(this.getRoleArn()) == false)
            return false;
        if (other.getSyncType() == null ^ this.getSyncType() == null)
            return false;
        if (other.getSyncType() != null && other.getSyncType().equals(this.getSyncType()) == false)
            return false;
        if (other.getPublishDeploymentStatus() == null ^ this.getPublishDeploymentStatus() == null)
            return false;
        if (other.getPublishDeploymentStatus() != null && other.getPublishDeploymentStatus().equals(this.getPublishDeploymentStatus()) == false)
            return false;
        if (other.getTriggerResourceUpdateOn() == null ^ this.getTriggerResourceUpdateOn() == null)
            return false;
        if (other.getTriggerResourceUpdateOn() != null && other.getTriggerResourceUpdateOn().equals(this.getTriggerResourceUpdateOn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBranch() == null) ? 0 : getBranch().hashCode());
        hashCode = prime * hashCode + ((getConfigFile() == null) ? 0 : getConfigFile().hashCode());
        hashCode = prime * hashCode + ((getOwnerId() == null) ? 0 : getOwnerId().hashCode());
        hashCode = prime * hashCode + ((getProviderType() == null) ? 0 : getProviderType().hashCode());
        hashCode = prime * hashCode + ((getRepositoryLinkId() == null) ? 0 : getRepositoryLinkId().hashCode());
        hashCode = prime * hashCode + ((getRepositoryName() == null) ? 0 : getRepositoryName().hashCode());
        hashCode = prime * hashCode + ((getResourceName() == null) ? 0 : getResourceName().hashCode());
        hashCode = prime * hashCode + ((getRoleArn() == null) ? 0 : getRoleArn().hashCode());
        hashCode = prime * hashCode + ((getSyncType() == null) ? 0 : getSyncType().hashCode());
        hashCode = prime * hashCode + ((getPublishDeploymentStatus() == null) ? 0 : getPublishDeploymentStatus().hashCode());
        hashCode = prime * hashCode + ((getTriggerResourceUpdateOn() == null) ? 0 : getTriggerResourceUpdateOn().hashCode());
        return hashCode;
    }

    @Override
    public SyncConfiguration clone() {
        try {
            return (SyncConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.codestarconnections.model.transform.SyncConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
