/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.comprehend.model.LanguageCode;
import com.amazonaws.services.comprehend.model.TextSegment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectToxicContentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<TextSegment> textSegments;
    private String languageCode;

    public List<TextSegment> getTextSegments() {
        return this.textSegments;
    }

    public void setTextSegments(Collection<TextSegment> textSegments) {
        if (textSegments == null) {
            this.textSegments = null;
            return;
        }
        this.textSegments = new ArrayList<TextSegment>(textSegments);
    }

    public DetectToxicContentRequest withTextSegments(TextSegment ... textSegments) {
        if (this.textSegments == null) {
            this.setTextSegments(new ArrayList<TextSegment>(textSegments.length));
        }
        for (TextSegment ele : textSegments) {
            this.textSegments.add(ele);
        }
        return this;
    }

    public DetectToxicContentRequest withTextSegments(Collection<TextSegment> textSegments) {
        this.setTextSegments(textSegments);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public DetectToxicContentRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public DetectToxicContentRequest withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTextSegments() != null) {
            sb.append("TextSegments: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectToxicContentRequest)) {
            return false;
        }
        DetectToxicContentRequest other = (DetectToxicContentRequest)obj;
        if (other.getTextSegments() == null ^ this.getTextSegments() == null) {
            return false;
        }
        if (other.getTextSegments() != null && !other.getTextSegments().equals(this.getTextSegments())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        return other.getLanguageCode() == null || other.getLanguageCode().equals(this.getLanguageCode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTextSegments() == null ? 0 : this.getTextSegments().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        return hashCode;
    }

    public DetectToxicContentRequest clone() {
        return (DetectToxicContentRequest)super.clone();
    }
}

