/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.RDSDBUtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.RDSInstanceSavingsOpportunityAfterDiscounts;
import com.amazonaws.services.computeoptimizer.model.SavingsOpportunity;
import com.amazonaws.services.computeoptimizer.model.transform.RDSDBInstanceRecommendationOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RDSDBInstanceRecommendationOption
implements Serializable,
Cloneable,
StructuredPojo {
    private String dbInstanceClass;
    private List<RDSDBUtilizationMetric> projectedUtilizationMetrics;
    private Double performanceRisk;
    private Integer rank;
    private SavingsOpportunity savingsOpportunity;
    private RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;

    public void setDbInstanceClass(String dbInstanceClass) {
        this.dbInstanceClass = dbInstanceClass;
    }

    public String getDbInstanceClass() {
        return this.dbInstanceClass;
    }

    public RDSDBInstanceRecommendationOption withDbInstanceClass(String dbInstanceClass) {
        this.setDbInstanceClass(dbInstanceClass);
        return this;
    }

    public List<RDSDBUtilizationMetric> getProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public void setProjectedUtilizationMetrics(Collection<RDSDBUtilizationMetric> projectedUtilizationMetrics) {
        if (projectedUtilizationMetrics == null) {
            this.projectedUtilizationMetrics = null;
            return;
        }
        this.projectedUtilizationMetrics = new ArrayList<RDSDBUtilizationMetric>(projectedUtilizationMetrics);
    }

    public RDSDBInstanceRecommendationOption withProjectedUtilizationMetrics(RDSDBUtilizationMetric ... projectedUtilizationMetrics) {
        if (this.projectedUtilizationMetrics == null) {
            this.setProjectedUtilizationMetrics(new ArrayList<RDSDBUtilizationMetric>(projectedUtilizationMetrics.length));
        }
        for (RDSDBUtilizationMetric ele : projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics.add(ele);
        }
        return this;
    }

    public RDSDBInstanceRecommendationOption withProjectedUtilizationMetrics(Collection<RDSDBUtilizationMetric> projectedUtilizationMetrics) {
        this.setProjectedUtilizationMetrics(projectedUtilizationMetrics);
        return this;
    }

    public void setPerformanceRisk(Double performanceRisk) {
        this.performanceRisk = performanceRisk;
    }

    public Double getPerformanceRisk() {
        return this.performanceRisk;
    }

    public RDSDBInstanceRecommendationOption withPerformanceRisk(Double performanceRisk) {
        this.setPerformanceRisk(performanceRisk);
        return this;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getRank() {
        return this.rank;
    }

    public RDSDBInstanceRecommendationOption withRank(Integer rank) {
        this.setRank(rank);
        return this;
    }

    public void setSavingsOpportunity(SavingsOpportunity savingsOpportunity) {
        this.savingsOpportunity = savingsOpportunity;
    }

    public SavingsOpportunity getSavingsOpportunity() {
        return this.savingsOpportunity;
    }

    public RDSDBInstanceRecommendationOption withSavingsOpportunity(SavingsOpportunity savingsOpportunity) {
        this.setSavingsOpportunity(savingsOpportunity);
        return this;
    }

    public void setSavingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
        this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
    }

    public RDSInstanceSavingsOpportunityAfterDiscounts getSavingsOpportunityAfterDiscounts() {
        return this.savingsOpportunityAfterDiscounts;
    }

    public RDSDBInstanceRecommendationOption withSavingsOpportunityAfterDiscounts(RDSInstanceSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
        this.setSavingsOpportunityAfterDiscounts(savingsOpportunityAfterDiscounts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDbInstanceClass() != null) {
            sb.append("DbInstanceClass: ").append(this.getDbInstanceClass()).append(",");
        }
        if (this.getProjectedUtilizationMetrics() != null) {
            sb.append("ProjectedUtilizationMetrics: ").append(this.getProjectedUtilizationMetrics()).append(",");
        }
        if (this.getPerformanceRisk() != null) {
            sb.append("PerformanceRisk: ").append(this.getPerformanceRisk()).append(",");
        }
        if (this.getRank() != null) {
            sb.append("Rank: ").append(this.getRank()).append(",");
        }
        if (this.getSavingsOpportunity() != null) {
            sb.append("SavingsOpportunity: ").append(this.getSavingsOpportunity()).append(",");
        }
        if (this.getSavingsOpportunityAfterDiscounts() != null) {
            sb.append("SavingsOpportunityAfterDiscounts: ").append(this.getSavingsOpportunityAfterDiscounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDBInstanceRecommendationOption)) {
            return false;
        }
        RDSDBInstanceRecommendationOption other = (RDSDBInstanceRecommendationOption)obj;
        if (other.getDbInstanceClass() == null ^ this.getDbInstanceClass() == null) {
            return false;
        }
        if (other.getDbInstanceClass() != null && !other.getDbInstanceClass().equals(this.getDbInstanceClass())) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() == null ^ this.getProjectedUtilizationMetrics() == null) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() != null && !other.getProjectedUtilizationMetrics().equals(this.getProjectedUtilizationMetrics())) {
            return false;
        }
        if (other.getPerformanceRisk() == null ^ this.getPerformanceRisk() == null) {
            return false;
        }
        if (other.getPerformanceRisk() != null && !other.getPerformanceRisk().equals(this.getPerformanceRisk())) {
            return false;
        }
        if (other.getRank() == null ^ this.getRank() == null) {
            return false;
        }
        if (other.getRank() != null && !other.getRank().equals(this.getRank())) {
            return false;
        }
        if (other.getSavingsOpportunity() == null ^ this.getSavingsOpportunity() == null) {
            return false;
        }
        if (other.getSavingsOpportunity() != null && !other.getSavingsOpportunity().equals(this.getSavingsOpportunity())) {
            return false;
        }
        if (other.getSavingsOpportunityAfterDiscounts() == null ^ this.getSavingsOpportunityAfterDiscounts() == null) {
            return false;
        }
        return other.getSavingsOpportunityAfterDiscounts() == null || other.getSavingsOpportunityAfterDiscounts().equals(this.getSavingsOpportunityAfterDiscounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDbInstanceClass() == null ? 0 : this.getDbInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getProjectedUtilizationMetrics() == null ? 0 : this.getProjectedUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceRisk() == null ? 0 : this.getPerformanceRisk().hashCode());
        hashCode = 31 * hashCode + (this.getRank() == null ? 0 : this.getRank().hashCode());
        hashCode = 31 * hashCode + (this.getSavingsOpportunity() == null ? 0 : this.getSavingsOpportunity().hashCode());
        hashCode = 31 * hashCode + (this.getSavingsOpportunityAfterDiscounts() == null ? 0 : this.getSavingsOpportunityAfterDiscounts().hashCode());
        return hashCode;
    }

    public RDSDBInstanceRecommendationOption clone() {
        try {
            return (RDSDBInstanceRecommendationOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDSDBInstanceRecommendationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

