/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.EvaluationFormItem;
import com.amazonaws.services.connect.model.transform.EvaluationFormSectionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EvaluationFormSection
implements Serializable,
Cloneable,
StructuredPojo {
    private String title;
    private String refId;
    private String instructions;
    private List<EvaluationFormItem> items;
    private Double weight;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public EvaluationFormSection withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public String getRefId() {
        return this.refId;
    }

    public EvaluationFormSection withRefId(String refId) {
        this.setRefId(refId);
        return this;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public EvaluationFormSection withInstructions(String instructions) {
        this.setInstructions(instructions);
        return this;
    }

    public List<EvaluationFormItem> getItems() {
        return this.items;
    }

    public void setItems(Collection<EvaluationFormItem> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new ArrayList<EvaluationFormItem>(items);
    }

    public EvaluationFormSection withItems(EvaluationFormItem ... items) {
        if (this.items == null) {
            this.setItems(new ArrayList<EvaluationFormItem>(items.length));
        }
        for (EvaluationFormItem ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public EvaluationFormSection withItems(Collection<EvaluationFormItem> items) {
        this.setItems(items);
        return this;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Double getWeight() {
        return this.weight;
    }

    public EvaluationFormSection withWeight(Double weight) {
        this.setWeight(weight);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getRefId() != null) {
            sb.append("RefId: ").append(this.getRefId()).append(",");
        }
        if (this.getInstructions() != null) {
            sb.append("Instructions: ").append(this.getInstructions()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems()).append(",");
        }
        if (this.getWeight() != null) {
            sb.append("Weight: ").append(this.getWeight());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSection)) {
            return false;
        }
        EvaluationFormSection other = (EvaluationFormSection)obj;
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getRefId() == null ^ this.getRefId() == null) {
            return false;
        }
        if (other.getRefId() != null && !other.getRefId().equals(this.getRefId())) {
            return false;
        }
        if (other.getInstructions() == null ^ this.getInstructions() == null) {
            return false;
        }
        if (other.getInstructions() != null && !other.getInstructions().equals(this.getInstructions())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getWeight() == null ^ this.getWeight() == null) {
            return false;
        }
        return other.getWeight() == null || other.getWeight().equals(this.getWeight());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getRefId() == null ? 0 : this.getRefId().hashCode());
        hashCode = 31 * hashCode + (this.getInstructions() == null ? 0 : this.getInstructions().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getWeight() == null ? 0 : this.getWeight().hashCode());
        return hashCode;
    }

    public EvaluationFormSection clone() {
        try {
            return (EvaluationFormSection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationFormSectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

