/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.MonitorCapability;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MonitorContactRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private String contactId;
    private String userId;
    private List<String> allowedMonitorCapabilities;
    private String clientToken;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public MonitorContactRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public String getContactId() {
        return this.contactId;
    }

    public MonitorContactRequest withContactId(String contactId) {
        this.setContactId(contactId);
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public MonitorContactRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public List<String> getAllowedMonitorCapabilities() {
        return this.allowedMonitorCapabilities;
    }

    public void setAllowedMonitorCapabilities(Collection<String> allowedMonitorCapabilities) {
        if (allowedMonitorCapabilities == null) {
            this.allowedMonitorCapabilities = null;
            return;
        }
        this.allowedMonitorCapabilities = new ArrayList<String>(allowedMonitorCapabilities);
    }

    public MonitorContactRequest withAllowedMonitorCapabilities(String ... allowedMonitorCapabilities) {
        if (this.allowedMonitorCapabilities == null) {
            this.setAllowedMonitorCapabilities(new ArrayList<String>(allowedMonitorCapabilities.length));
        }
        for (String ele : allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities.add(ele);
        }
        return this;
    }

    public MonitorContactRequest withAllowedMonitorCapabilities(Collection<String> allowedMonitorCapabilities) {
        this.setAllowedMonitorCapabilities(allowedMonitorCapabilities);
        return this;
    }

    public MonitorContactRequest withAllowedMonitorCapabilities(MonitorCapability ... allowedMonitorCapabilities) {
        ArrayList<String> allowedMonitorCapabilitiesCopy = new ArrayList<String>(allowedMonitorCapabilities.length);
        for (MonitorCapability value : allowedMonitorCapabilities) {
            allowedMonitorCapabilitiesCopy.add(value.toString());
        }
        if (this.getAllowedMonitorCapabilities() == null) {
            this.setAllowedMonitorCapabilities(allowedMonitorCapabilitiesCopy);
        } else {
            this.getAllowedMonitorCapabilities().addAll(allowedMonitorCapabilitiesCopy);
        }
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public MonitorContactRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getContactId() != null) {
            sb.append("ContactId: ").append(this.getContactId()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId()).append(",");
        }
        if (this.getAllowedMonitorCapabilities() != null) {
            sb.append("AllowedMonitorCapabilities: ").append(this.getAllowedMonitorCapabilities()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorContactRequest)) {
            return false;
        }
        MonitorContactRequest other = (MonitorContactRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getContactId() == null ^ this.getContactId() == null) {
            return false;
        }
        if (other.getContactId() != null && !other.getContactId().equals(this.getContactId())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        if (other.getUserId() != null && !other.getUserId().equals(this.getUserId())) {
            return false;
        }
        if (other.getAllowedMonitorCapabilities() == null ^ this.getAllowedMonitorCapabilities() == null) {
            return false;
        }
        if (other.getAllowedMonitorCapabilities() != null && !other.getAllowedMonitorCapabilities().equals(this.getAllowedMonitorCapabilities())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getContactId() == null ? 0 : this.getContactId().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedMonitorCapabilities() == null ? 0 : this.getAllowedMonitorCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public MonitorContactRequest clone() {
        return (MonitorContactRequest)super.clone();
    }
}

