/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.connect.model.UserSearchSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchUsersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<UserSearchSummary> users;
    private String nextToken;
    private Long approximateTotalCount;

    public List<UserSearchSummary> getUsers() {
        return this.users;
    }

    public void setUsers(Collection<UserSearchSummary> users) {
        if (users == null) {
            this.users = null;
            return;
        }
        this.users = new ArrayList<UserSearchSummary>(users);
    }

    public SearchUsersResult withUsers(UserSearchSummary ... users) {
        if (this.users == null) {
            this.setUsers(new ArrayList<UserSearchSummary>(users.length));
        }
        for (UserSearchSummary ele : users) {
            this.users.add(ele);
        }
        return this;
    }

    public SearchUsersResult withUsers(Collection<UserSearchSummary> users) {
        this.setUsers(users);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchUsersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setApproximateTotalCount(Long approximateTotalCount) {
        this.approximateTotalCount = approximateTotalCount;
    }

    public Long getApproximateTotalCount() {
        return this.approximateTotalCount;
    }

    public SearchUsersResult withApproximateTotalCount(Long approximateTotalCount) {
        this.setApproximateTotalCount(approximateTotalCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUsers() != null) {
            sb.append("Users: ").append(this.getUsers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getApproximateTotalCount() != null) {
            sb.append("ApproximateTotalCount: ").append(this.getApproximateTotalCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersResult)) {
            return false;
        }
        SearchUsersResult other = (SearchUsersResult)obj;
        if (other.getUsers() == null ^ this.getUsers() == null) {
            return false;
        }
        if (other.getUsers() != null && !other.getUsers().equals(this.getUsers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getApproximateTotalCount() == null ^ this.getApproximateTotalCount() == null) {
            return false;
        }
        return other.getApproximateTotalCount() == null || other.getApproximateTotalCount().equals(this.getApproximateTotalCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUsers() == null ? 0 : this.getUsers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getApproximateTotalCount() == null ? 0 : this.getApproximateTotalCount().hashCode());
        return hashCode;
    }

    public SearchUsersResult clone() {
        try {
            return (SearchUsersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

