/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.ViewContent;
import com.amazonaws.services.connect.model.ViewStatus;
import com.amazonaws.services.connect.model.ViewType;
import com.amazonaws.services.connect.model.transform.ViewMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class View
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String arn;
    private String name;
    private String status;
    private String type;
    private String description;
    private Integer version;
    private String versionDescription;
    private ViewContent content;
    private Map<String, String> tags;
    private Date createdTime;
    private Date lastModifiedTime;
    private String viewContentSha256;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public View withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public View withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public View withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public View withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public View withStatus(ViewStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public View withType(String type) {
        this.setType(type);
        return this;
    }

    public View withType(ViewType type) {
        this.type = type.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public View withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public View withVersion(Integer version) {
        this.setVersion(version);
        return this;
    }

    public void setVersionDescription(String versionDescription) {
        this.versionDescription = versionDescription;
    }

    public String getVersionDescription() {
        return this.versionDescription;
    }

    public View withVersionDescription(String versionDescription) {
        this.setVersionDescription(versionDescription);
        return this;
    }

    public void setContent(ViewContent content) {
        this.content = content;
    }

    public ViewContent getContent() {
        return this.content;
    }

    public View withContent(ViewContent content) {
        this.setContent(content);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public View withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public View addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public View clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public View withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public View withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public void setViewContentSha256(String viewContentSha256) {
        this.viewContentSha256 = viewContentSha256;
    }

    public String getViewContentSha256() {
        return this.viewContentSha256;
    }

    public View withViewContentSha256(String viewContentSha256) {
        this.setViewContentSha256(viewContentSha256);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getVersionDescription() != null) {
            sb.append("VersionDescription: ").append(this.getVersionDescription()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getViewContentSha256() != null) {
            sb.append("ViewContentSha256: ").append(this.getViewContentSha256());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof View)) {
            return false;
        }
        View other = (View)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getVersionDescription() == null ^ this.getVersionDescription() == null) {
            return false;
        }
        if (other.getVersionDescription() != null && !other.getVersionDescription().equals(this.getVersionDescription())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getViewContentSha256() == null ^ this.getViewContentSha256() == null) {
            return false;
        }
        return other.getViewContentSha256() == null || other.getViewContentSha256().equals(this.getViewContentSha256());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getVersionDescription() == null ? 0 : this.getVersionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getViewContentSha256() == null ? 0 : this.getViewContentSha256().hashCode());
        return hashCode;
    }

    public View clone() {
        try {
            return (View)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ViewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

