/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connectcampaign.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * GetCampaignStateBatchResponse
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/GetCampaignStateBatch"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetCampaignStateBatchResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    private java.util.List<SuccessfulCampaignStateResponse> successfulRequests;

    private java.util.List<FailedCampaignStateResponse> failedRequests;

    /**
     * @return
     */

    public java.util.List<SuccessfulCampaignStateResponse> getSuccessfulRequests() {
        return successfulRequests;
    }

    /**
     * @param successfulRequests
     */

    public void setSuccessfulRequests(java.util.Collection<SuccessfulCampaignStateResponse> successfulRequests) {
        if (successfulRequests == null) {
            this.successfulRequests = null;
            return;
        }

        this.successfulRequests = new java.util.ArrayList<SuccessfulCampaignStateResponse>(successfulRequests);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSuccessfulRequests(java.util.Collection)} or {@link #withSuccessfulRequests(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param successfulRequests
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetCampaignStateBatchResult withSuccessfulRequests(SuccessfulCampaignStateResponse... successfulRequests) {
        if (this.successfulRequests == null) {
            setSuccessfulRequests(new java.util.ArrayList<SuccessfulCampaignStateResponse>(successfulRequests.length));
        }
        for (SuccessfulCampaignStateResponse ele : successfulRequests) {
            this.successfulRequests.add(ele);
        }
        return this;
    }

    /**
     * @param successfulRequests
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetCampaignStateBatchResult withSuccessfulRequests(java.util.Collection<SuccessfulCampaignStateResponse> successfulRequests) {
        setSuccessfulRequests(successfulRequests);
        return this;
    }

    /**
     * @return
     */

    public java.util.List<FailedCampaignStateResponse> getFailedRequests() {
        return failedRequests;
    }

    /**
     * @param failedRequests
     */

    public void setFailedRequests(java.util.Collection<FailedCampaignStateResponse> failedRequests) {
        if (failedRequests == null) {
            this.failedRequests = null;
            return;
        }

        this.failedRequests = new java.util.ArrayList<FailedCampaignStateResponse>(failedRequests);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFailedRequests(java.util.Collection)} or {@link #withFailedRequests(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param failedRequests
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetCampaignStateBatchResult withFailedRequests(FailedCampaignStateResponse... failedRequests) {
        if (this.failedRequests == null) {
            setFailedRequests(new java.util.ArrayList<FailedCampaignStateResponse>(failedRequests.length));
        }
        for (FailedCampaignStateResponse ele : failedRequests) {
            this.failedRequests.add(ele);
        }
        return this;
    }

    /**
     * @param failedRequests
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetCampaignStateBatchResult withFailedRequests(java.util.Collection<FailedCampaignStateResponse> failedRequests) {
        setFailedRequests(failedRequests);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSuccessfulRequests() != null)
            sb.append("SuccessfulRequests: ").append(getSuccessfulRequests()).append(",");
        if (getFailedRequests() != null)
            sb.append("FailedRequests: ").append(getFailedRequests());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetCampaignStateBatchResult == false)
            return false;
        GetCampaignStateBatchResult other = (GetCampaignStateBatchResult) obj;
        if (other.getSuccessfulRequests() == null ^ this.getSuccessfulRequests() == null)
            return false;
        if (other.getSuccessfulRequests() != null && other.getSuccessfulRequests().equals(this.getSuccessfulRequests()) == false)
            return false;
        if (other.getFailedRequests() == null ^ this.getFailedRequests() == null)
            return false;
        if (other.getFailedRequests() != null && other.getFailedRequests().equals(this.getFailedRequests()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSuccessfulRequests() == null) ? 0 : getSuccessfulRequests().hashCode());
        hashCode = prime * hashCode + ((getFailedRequests() == null) ? 0 : getFailedRequests().hashCode());
        return hashCode;
    }

    @Override
    public GetCampaignStateBatchResult clone() {
        try {
            return (GetCampaignStateBatchResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
