/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcases.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.connectcases.model.LayoutSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLayoutsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<LayoutSummary> layouts;
    private String nextToken;

    public List<LayoutSummary> getLayouts() {
        return this.layouts;
    }

    public void setLayouts(Collection<LayoutSummary> layouts) {
        if (layouts == null) {
            this.layouts = null;
            return;
        }
        this.layouts = new ArrayList<LayoutSummary>(layouts);
    }

    public ListLayoutsResult withLayouts(LayoutSummary ... layouts) {
        if (this.layouts == null) {
            this.setLayouts(new ArrayList<LayoutSummary>(layouts.length));
        }
        for (LayoutSummary ele : layouts) {
            this.layouts.add(ele);
        }
        return this;
    }

    public ListLayoutsResult withLayouts(Collection<LayoutSummary> layouts) {
        this.setLayouts(layouts);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLayoutsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLayouts() != null) {
            sb.append("Layouts: ").append(this.getLayouts()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayoutsResult)) {
            return false;
        }
        ListLayoutsResult other = (ListLayoutsResult)obj;
        if (other.getLayouts() == null ^ this.getLayouts() == null) {
            return false;
        }
        if (other.getLayouts() != null && !other.getLayouts().equals(this.getLayouts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLayouts() == null ? 0 : this.getLayouts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListLayoutsResult clone() {
        try {
            return (ListLayoutsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

