/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.costexplorer.model.ApproximationDimension;
import com.amazonaws.services.costexplorer.model.Granularity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetApproximateUsageRecordsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String granularity;
    private List<String> services;
    private String approximationDimension;

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public GetApproximateUsageRecordsRequest withGranularity(String granularity) {
        this.setGranularity(granularity);
        return this;
    }

    public GetApproximateUsageRecordsRequest withGranularity(Granularity granularity) {
        this.granularity = granularity.toString();
        return this;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(Collection<String> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        this.services = new ArrayList<String>(services);
    }

    public GetApproximateUsageRecordsRequest withServices(String ... services) {
        if (this.services == null) {
            this.setServices(new ArrayList<String>(services.length));
        }
        for (String ele : services) {
            this.services.add(ele);
        }
        return this;
    }

    public GetApproximateUsageRecordsRequest withServices(Collection<String> services) {
        this.setServices(services);
        return this;
    }

    public void setApproximationDimension(String approximationDimension) {
        this.approximationDimension = approximationDimension;
    }

    public String getApproximationDimension() {
        return this.approximationDimension;
    }

    public GetApproximateUsageRecordsRequest withApproximationDimension(String approximationDimension) {
        this.setApproximationDimension(approximationDimension);
        return this;
    }

    public GetApproximateUsageRecordsRequest withApproximationDimension(ApproximationDimension approximationDimension) {
        this.approximationDimension = approximationDimension.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGranularity() != null) {
            sb.append("Granularity: ").append(this.getGranularity()).append(",");
        }
        if (this.getServices() != null) {
            sb.append("Services: ").append(this.getServices()).append(",");
        }
        if (this.getApproximationDimension() != null) {
            sb.append("ApproximationDimension: ").append(this.getApproximationDimension());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApproximateUsageRecordsRequest)) {
            return false;
        }
        GetApproximateUsageRecordsRequest other = (GetApproximateUsageRecordsRequest)obj;
        if (other.getGranularity() == null ^ this.getGranularity() == null) {
            return false;
        }
        if (other.getGranularity() != null && !other.getGranularity().equals(this.getGranularity())) {
            return false;
        }
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        if (other.getServices() != null && !other.getServices().equals(this.getServices())) {
            return false;
        }
        if (other.getApproximationDimension() == null ^ this.getApproximationDimension() == null) {
            return false;
        }
        return other.getApproximationDimension() == null || other.getApproximationDimension().equals(this.getApproximationDimension());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGranularity() == null ? 0 : this.getGranularity().hashCode());
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        hashCode = 31 * hashCode + (this.getApproximationDimension() == null ? 0 : this.getApproximationDimension().hashCode());
        return hashCode;
    }

    public GetApproximateUsageRecordsRequest clone() {
        return (GetApproximateUsageRecordsRequest)super.clone();
    }
}

