/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.datasync.model;

import javax.annotation.Generated;

/**
 * <p>
 * This exception is thrown when the client submits a malformed request.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class InvalidRequestException extends com.amazonaws.services.datasync.model.AWSDataSyncException {
    private static final long serialVersionUID = 1L;

    private String errorCode;

    private String datasyncErrorCode;

    /**
     * Constructs a new InvalidRequestException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public InvalidRequestException(String message) {
        super(message);
    }

    /**
     * @param errorCode
     */

    @com.fasterxml.jackson.annotation.JsonProperty("errorCode")
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * @return
     */

    @com.fasterxml.jackson.annotation.JsonProperty("errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * @param errorCode
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InvalidRequestException withErrorCode(String errorCode) {
        setErrorCode(errorCode);
        return this;
    }

    /**
     * @param datasyncErrorCode
     */

    @com.fasterxml.jackson.annotation.JsonProperty("datasyncErrorCode")
    public void setDatasyncErrorCode(String datasyncErrorCode) {
        this.datasyncErrorCode = datasyncErrorCode;
    }

    /**
     * @return
     */

    @com.fasterxml.jackson.annotation.JsonProperty("datasyncErrorCode")
    public String getDatasyncErrorCode() {
        return this.datasyncErrorCode;
    }

    /**
     * @param datasyncErrorCode
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public InvalidRequestException withDatasyncErrorCode(String datasyncErrorCode) {
        setDatasyncErrorCode(datasyncErrorCode);
        return this;
    }

}
