/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.devopsguru.model.TagCollection;
import java.util.List;

@SdkInternalApi
public class TagCollectionMarshaller {
    private static final MarshallingInfo<String> APPBOUNDARYKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppBoundaryKey").build();
    private static final MarshallingInfo<List> TAGVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagValues").build();
    private static final TagCollectionMarshaller instance = new TagCollectionMarshaller();

    public static TagCollectionMarshaller getInstance() {
        return instance;
    }

    public void marshall(TagCollection tagCollection, ProtocolMarshaller protocolMarshaller) {
        if (tagCollection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tagCollection.getAppBoundaryKey(), APPBOUNDARYKEY_BINDING);
            protocolMarshaller.marshall(tagCollection.getTagValues(), TAGVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

