/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.databasemigrationservice.model.EngineVersion;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EngineVersionMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<String> LIFECYCLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lifecycle").build();
    private static final MarshallingInfo<String> RELEASESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseStatus").build();
    private static final MarshallingInfo<Date> LAUNCHDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> AUTOUPGRADEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoUpgradeDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DEPRECATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeprecationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> FORCEUPGRADEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForceUpgradeDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> AVAILABLEUPGRADES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailableUpgrades").build();
    private static final EngineVersionMarshaller instance = new EngineVersionMarshaller();

    public static EngineVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(EngineVersion engineVersion, ProtocolMarshaller protocolMarshaller) {
        if (engineVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)engineVersion.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)engineVersion.getLifecycle(), LIFECYCLE_BINDING);
            protocolMarshaller.marshall((Object)engineVersion.getReleaseStatus(), RELEASESTATUS_BINDING);
            protocolMarshaller.marshall((Object)engineVersion.getLaunchDate(), LAUNCHDATE_BINDING);
            protocolMarshaller.marshall((Object)engineVersion.getAutoUpgradeDate(), AUTOUPGRADEDATE_BINDING);
            protocolMarshaller.marshall((Object)engineVersion.getDeprecationDate(), DEPRECATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)engineVersion.getForceUpgradeDate(), FORCEUPGRADEDATE_BINDING);
            protocolMarshaller.marshall(engineVersion.getAvailableUpgrades(), AVAILABLEUPGRADES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

