/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.docdb.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.docdb.model.DescribeEventCategoriesRequest;
import com.amazonaws.services.docdb.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeEventCategoriesRequestMarshaller
implements Marshaller<Request<DescribeEventCategoriesRequest>, DescribeEventCategoriesRequest> {
    public Request<DescribeEventCategoriesRequest> marshall(DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        if (describeEventCategoriesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventCategoriesRequest, "AmazonDocDB");
        request.addParameter("Action", "DescribeEventCategories");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventCategoriesRequest.getSourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)describeEventCategoriesRequest.getSourceType()));
        }
        if (describeEventCategoriesRequest.getFilters() != null) {
            List<Filter> filtersList = describeEventCategoriesRequest.getFilters();
            if (filtersList.isEmpty()) {
                request.addParameter("Filters", "");
            } else {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (filtersListValue.getValues() != null) {
                        List<String> valuesList = filtersListValue.getValues();
                        if (valuesList.isEmpty()) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        } else {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        }
                    }
                    ++filtersListIndex;
                }
            }
        }
        return request;
    }
}

