/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DnsEntry;
import com.amazonaws.services.ec2.model.SecurityGroupIdentifier;
import com.amazonaws.services.ec2.model.VpcEndpoint;
import com.amazonaws.services.ec2.model.transform.DnsEntryStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.SecurityGroupIdentifierStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class VpcEndpointStaxUnmarshaller
implements Unmarshaller<VpcEndpoint, StaxUnmarshallerContext> {
    private static VpcEndpointStaxUnmarshaller instance;

    public VpcEndpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        VpcEndpoint vpcEndpoint = new VpcEndpoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return vpcEndpoint;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("vpcEndpointId", targetDepth)) {
                    vpcEndpoint.setVpcEndpointId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcEndpointType", targetDepth)) {
                    vpcEndpoint.setVpcEndpointType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcId", targetDepth)) {
                    vpcEndpoint.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("serviceName", targetDepth)) {
                    vpcEndpoint.setServiceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    vpcEndpoint.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("policyDocument", targetDepth)) {
                    vpcEndpoint.setPolicyDocument(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("routeTableIdSet", targetDepth)) {
                    vpcEndpoint.withRouteTableIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("routeTableIdSet/item", targetDepth)) {
                    vpcEndpoint.withRouteTableIds(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("subnetIdSet", targetDepth)) {
                    vpcEndpoint.withSubnetIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("subnetIdSet/item", targetDepth)) {
                    vpcEndpoint.withSubnetIds(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupSet", targetDepth)) {
                    vpcEndpoint.withGroups(new ArrayList<SecurityGroupIdentifier>());
                    continue;
                }
                if (context.testExpression("groupSet/item", targetDepth)) {
                    vpcEndpoint.withGroups(SecurityGroupIdentifierStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("privateDnsEnabled", targetDepth)) {
                    vpcEndpoint.setPrivateDnsEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkInterfaceIdSet", targetDepth)) {
                    vpcEndpoint.withNetworkInterfaceIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("networkInterfaceIdSet/item", targetDepth)) {
                    vpcEndpoint.withNetworkInterfaceIds(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("dnsEntrySet", targetDepth)) {
                    vpcEndpoint.withDnsEntries(new ArrayList<DnsEntry>());
                    continue;
                }
                if (context.testExpression("dnsEntrySet/item", targetDepth)) {
                    vpcEndpoint.withDnsEntries(DnsEntryStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("creationTimestamp", targetDepth)) continue;
                vpcEndpoint.setCreationTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return vpcEndpoint;
    }

    public static VpcEndpointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new VpcEndpointStaxUnmarshaller();
        }
        return instance;
    }
}

