/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.transform.TaskOverrideMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TaskOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalList<ContainerOverride> containerOverrides;
    private String taskRoleArn;
    private String executionRoleArn;

    public List<ContainerOverride> getContainerOverrides() {
        if (this.containerOverrides == null) {
            this.containerOverrides = new SdkInternalList();
        }
        return this.containerOverrides;
    }

    public void setContainerOverrides(Collection<ContainerOverride> containerOverrides) {
        if (containerOverrides == null) {
            this.containerOverrides = null;
            return;
        }
        this.containerOverrides = new SdkInternalList(containerOverrides);
    }

    public TaskOverride withContainerOverrides(ContainerOverride ... containerOverrides) {
        if (this.containerOverrides == null) {
            this.setContainerOverrides((Collection<ContainerOverride>)new SdkInternalList(containerOverrides.length));
        }
        for (ContainerOverride ele : containerOverrides) {
            this.containerOverrides.add((Object)ele);
        }
        return this;
    }

    public TaskOverride withContainerOverrides(Collection<ContainerOverride> containerOverrides) {
        this.setContainerOverrides(containerOverrides);
        return this;
    }

    public void setTaskRoleArn(String taskRoleArn) {
        this.taskRoleArn = taskRoleArn;
    }

    public String getTaskRoleArn() {
        return this.taskRoleArn;
    }

    public TaskOverride withTaskRoleArn(String taskRoleArn) {
        this.setTaskRoleArn(taskRoleArn);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public TaskOverride withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerOverrides() != null) {
            sb.append("ContainerOverrides: ").append(this.getContainerOverrides()).append(",");
        }
        if (this.getTaskRoleArn() != null) {
            sb.append("TaskRoleArn: ").append(this.getTaskRoleArn()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskOverride)) {
            return false;
        }
        TaskOverride other = (TaskOverride)obj;
        if (other.getContainerOverrides() == null ^ this.getContainerOverrides() == null) {
            return false;
        }
        if (other.getContainerOverrides() != null && !other.getContainerOverrides().equals(this.getContainerOverrides())) {
            return false;
        }
        if (other.getTaskRoleArn() == null ^ this.getTaskRoleArn() == null) {
            return false;
        }
        if (other.getTaskRoleArn() != null && !other.getTaskRoleArn().equals(this.getTaskRoleArn())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        return other.getExecutionRoleArn() == null || other.getExecutionRoleArn().equals(this.getExecutionRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerOverrides() == null ? 0 : this.getContainerOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getTaskRoleArn() == null ? 0 : this.getTaskRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        return hashCode;
    }

    public TaskOverride clone() {
        try {
            return (TaskOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

