/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.eks.AmazonEKSAsync;
import com.amazonaws.services.eks.AmazonEKSAsyncClientBuilder;
import com.amazonaws.services.eks.AmazonEKSClient;
import com.amazonaws.services.eks.model.CreateClusterRequest;
import com.amazonaws.services.eks.model.CreateClusterResult;
import com.amazonaws.services.eks.model.DeleteClusterRequest;
import com.amazonaws.services.eks.model.DeleteClusterResult;
import com.amazonaws.services.eks.model.DescribeClusterRequest;
import com.amazonaws.services.eks.model.DescribeClusterResult;
import com.amazonaws.services.eks.model.DescribeUpdateRequest;
import com.amazonaws.services.eks.model.DescribeUpdateResult;
import com.amazonaws.services.eks.model.ListClustersRequest;
import com.amazonaws.services.eks.model.ListClustersResult;
import com.amazonaws.services.eks.model.ListTagsForResourceRequest;
import com.amazonaws.services.eks.model.ListTagsForResourceResult;
import com.amazonaws.services.eks.model.ListUpdatesRequest;
import com.amazonaws.services.eks.model.ListUpdatesResult;
import com.amazonaws.services.eks.model.TagResourceRequest;
import com.amazonaws.services.eks.model.TagResourceResult;
import com.amazonaws.services.eks.model.UntagResourceRequest;
import com.amazonaws.services.eks.model.UntagResourceResult;
import com.amazonaws.services.eks.model.UpdateClusterConfigRequest;
import com.amazonaws.services.eks.model.UpdateClusterConfigResult;
import com.amazonaws.services.eks.model.UpdateClusterVersionRequest;
import com.amazonaws.services.eks.model.UpdateClusterVersionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonEKSAsyncClient
extends AmazonEKSClient
implements AmazonEKSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonEKSAsyncClientBuilder asyncBuilder() {
        return AmazonEKSAsyncClientBuilder.standard();
    }

    AmazonEKSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request) {
        return this.describeClusterAsync(request, null);
    }

    @Override
    public Future<DescribeClusterResult> describeClusterAsync(DescribeClusterRequest request, final AsyncHandler<DescribeClusterRequest, DescribeClusterResult> asyncHandler) {
        final DescribeClusterRequest finalRequest = (DescribeClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClusterResult>(){

            @Override
            public DescribeClusterResult call() throws Exception {
                DescribeClusterResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUpdateResult> describeUpdateAsync(DescribeUpdateRequest request) {
        return this.describeUpdateAsync(request, null);
    }

    @Override
    public Future<DescribeUpdateResult> describeUpdateAsync(DescribeUpdateRequest request, final AsyncHandler<DescribeUpdateRequest, DescribeUpdateResult> asyncHandler) {
        final DescribeUpdateRequest finalRequest = (DescribeUpdateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUpdateResult>(){

            @Override
            public DescribeUpdateResult call() throws Exception {
                DescribeUpdateResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeDescribeUpdate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        final ListClustersRequest finalRequest = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUpdatesResult> listUpdatesAsync(ListUpdatesRequest request) {
        return this.listUpdatesAsync(request, null);
    }

    @Override
    public Future<ListUpdatesResult> listUpdatesAsync(ListUpdatesRequest request, final AsyncHandler<ListUpdatesRequest, ListUpdatesResult> asyncHandler) {
        final ListUpdatesRequest finalRequest = (ListUpdatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUpdatesResult>(){

            @Override
            public ListUpdatesResult call() throws Exception {
                ListUpdatesResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeListUpdates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterConfigResult> updateClusterConfigAsync(UpdateClusterConfigRequest request) {
        return this.updateClusterConfigAsync(request, null);
    }

    @Override
    public Future<UpdateClusterConfigResult> updateClusterConfigAsync(UpdateClusterConfigRequest request, final AsyncHandler<UpdateClusterConfigRequest, UpdateClusterConfigResult> asyncHandler) {
        final UpdateClusterConfigRequest finalRequest = (UpdateClusterConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterConfigResult>(){

            @Override
            public UpdateClusterConfigResult call() throws Exception {
                UpdateClusterConfigResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUpdateClusterConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterVersionResult> updateClusterVersionAsync(UpdateClusterVersionRequest request) {
        return this.updateClusterVersionAsync(request, null);
    }

    @Override
    public Future<UpdateClusterVersionResult> updateClusterVersionAsync(UpdateClusterVersionRequest request, final AsyncHandler<UpdateClusterVersionRequest, UpdateClusterVersionResult> asyncHandler) {
        final UpdateClusterVersionRequest finalRequest = (UpdateClusterVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterVersionResult>(){

            @Override
            public UpdateClusterVersionResult call() throws Exception {
                UpdateClusterVersionResult result = null;
                try {
                    result = AmazonEKSAsyncClient.this.executeUpdateClusterVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

