/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.Provider;
import com.amazonaws.services.eks.model.transform.EncryptionConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EncryptionConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> resources;
    private Provider provider;

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<String>(resources);
    }

    public EncryptionConfig withResources(String ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<String>(resources.length));
        }
        for (String ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public EncryptionConfig withResources(Collection<String> resources) {
        this.setResources(resources);
        return this;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public EncryptionConfig withProvider(Provider provider) {
        this.setProvider(provider);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getProvider() != null) {
            sb.append("Provider: ").append(this.getProvider());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfig)) {
            return false;
        }
        EncryptionConfig other = (EncryptionConfig)obj;
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getProvider() == null ^ this.getProvider() == null) {
            return false;
        }
        return other.getProvider() == null || other.getProvider().equals(this.getProvider());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getProvider() == null ? 0 : this.getProvider().hashCode());
        return hashCode;
    }

    public EncryptionConfig clone() {
        try {
            return (EncryptionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

