/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.ReshardingConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ReshardingConfigurationStaxUnmarshaller
implements Unmarshaller<ReshardingConfiguration, StaxUnmarshallerContext> {
    private static ReshardingConfigurationStaxUnmarshaller instance;

    public ReshardingConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReshardingConfiguration reshardingConfiguration = new ReshardingConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return reshardingConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("PreferredAvailabilityZones", targetDepth)) {
                    reshardingConfiguration.withPreferredAvailabilityZones(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("PreferredAvailabilityZones/AvailabilityZone", targetDepth)) continue;
                reshardingConfiguration.withPreferredAvailabilityZones(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return reshardingConfiguration;
    }

    public static ReshardingConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ReshardingConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

