/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SetSecurityGroupsRequestMarshaller
implements Marshaller<Request<SetSecurityGroupsRequest>, SetSecurityGroupsRequest> {
    public Request<SetSecurityGroupsRequest> marshall(SetSecurityGroupsRequest setSecurityGroupsRequest) {
        if (setSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSecurityGroupsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "SetSecurityGroups");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setSecurityGroupsRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)setSecurityGroupsRequest.getLoadBalancerArn()));
        }
        if (setSecurityGroupsRequest.getSecurityGroups() != null) {
            List<String> securityGroupsList = setSecurityGroupsRequest.getSecurityGroups();
            if (securityGroupsList.isEmpty()) {
                request.addParameter("SecurityGroups", "");
            } else {
                int securityGroupsListIndex = 1;
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue != null) {
                        request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        return request;
    }
}

