/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrcontainers.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.emrcontainers.model.JobDriver;
import com.amazonaws.services.emrcontainers.model.ParametricConfigurationOverrides;
import com.amazonaws.services.emrcontainers.model.TemplateParameterConfiguration;
import com.amazonaws.services.emrcontainers.model.transform.JobTemplateDataMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class JobTemplateData
implements Serializable,
Cloneable,
StructuredPojo {
    private String executionRoleArn;
    private String releaseLabel;
    private ParametricConfigurationOverrides configurationOverrides;
    private JobDriver jobDriver;
    private Map<String, TemplateParameterConfiguration> parameterConfiguration;
    private Map<String, String> jobTags;

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public JobTemplateData withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public void setReleaseLabel(String releaseLabel) {
        this.releaseLabel = releaseLabel;
    }

    public String getReleaseLabel() {
        return this.releaseLabel;
    }

    public JobTemplateData withReleaseLabel(String releaseLabel) {
        this.setReleaseLabel(releaseLabel);
        return this;
    }

    public void setConfigurationOverrides(ParametricConfigurationOverrides configurationOverrides) {
        this.configurationOverrides = configurationOverrides;
    }

    public ParametricConfigurationOverrides getConfigurationOverrides() {
        return this.configurationOverrides;
    }

    public JobTemplateData withConfigurationOverrides(ParametricConfigurationOverrides configurationOverrides) {
        this.setConfigurationOverrides(configurationOverrides);
        return this;
    }

    public void setJobDriver(JobDriver jobDriver) {
        this.jobDriver = jobDriver;
    }

    public JobDriver getJobDriver() {
        return this.jobDriver;
    }

    public JobTemplateData withJobDriver(JobDriver jobDriver) {
        this.setJobDriver(jobDriver);
        return this;
    }

    public Map<String, TemplateParameterConfiguration> getParameterConfiguration() {
        return this.parameterConfiguration;
    }

    public void setParameterConfiguration(Map<String, TemplateParameterConfiguration> parameterConfiguration) {
        this.parameterConfiguration = parameterConfiguration;
    }

    public JobTemplateData withParameterConfiguration(Map<String, TemplateParameterConfiguration> parameterConfiguration) {
        this.setParameterConfiguration(parameterConfiguration);
        return this;
    }

    public JobTemplateData addParameterConfigurationEntry(String key, TemplateParameterConfiguration value) {
        if (null == this.parameterConfiguration) {
            this.parameterConfiguration = new HashMap<String, TemplateParameterConfiguration>();
        }
        if (this.parameterConfiguration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameterConfiguration.put(key, value);
        return this;
    }

    public JobTemplateData clearParameterConfigurationEntries() {
        this.parameterConfiguration = null;
        return this;
    }

    public Map<String, String> getJobTags() {
        return this.jobTags;
    }

    public void setJobTags(Map<String, String> jobTags) {
        this.jobTags = jobTags;
    }

    public JobTemplateData withJobTags(Map<String, String> jobTags) {
        this.setJobTags(jobTags);
        return this;
    }

    public JobTemplateData addJobTagsEntry(String key, String value) {
        if (null == this.jobTags) {
            this.jobTags = new HashMap<String, String>();
        }
        if (this.jobTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.jobTags.put(key, value);
        return this;
    }

    public JobTemplateData clearJobTagsEntries() {
        this.jobTags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getReleaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.getReleaseLabel()).append(",");
        }
        if (this.getConfigurationOverrides() != null) {
            sb.append("ConfigurationOverrides: ").append(this.getConfigurationOverrides()).append(",");
        }
        if (this.getJobDriver() != null) {
            sb.append("JobDriver: ").append(this.getJobDriver()).append(",");
        }
        if (this.getParameterConfiguration() != null) {
            sb.append("ParameterConfiguration: ").append(this.getParameterConfiguration()).append(",");
        }
        if (this.getJobTags() != null) {
            sb.append("JobTags: ").append(this.getJobTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplateData)) {
            return false;
        }
        JobTemplateData other = (JobTemplateData)obj;
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getReleaseLabel() == null ^ this.getReleaseLabel() == null) {
            return false;
        }
        if (other.getReleaseLabel() != null && !other.getReleaseLabel().equals(this.getReleaseLabel())) {
            return false;
        }
        if (other.getConfigurationOverrides() == null ^ this.getConfigurationOverrides() == null) {
            return false;
        }
        if (other.getConfigurationOverrides() != null && !other.getConfigurationOverrides().equals(this.getConfigurationOverrides())) {
            return false;
        }
        if (other.getJobDriver() == null ^ this.getJobDriver() == null) {
            return false;
        }
        if (other.getJobDriver() != null && !other.getJobDriver().equals(this.getJobDriver())) {
            return false;
        }
        if (other.getParameterConfiguration() == null ^ this.getParameterConfiguration() == null) {
            return false;
        }
        if (other.getParameterConfiguration() != null && !other.getParameterConfiguration().equals(this.getParameterConfiguration())) {
            return false;
        }
        if (other.getJobTags() == null ^ this.getJobTags() == null) {
            return false;
        }
        return other.getJobTags() == null || other.getJobTags().equals(this.getJobTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseLabel() == null ? 0 : this.getReleaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationOverrides() == null ? 0 : this.getConfigurationOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getJobDriver() == null ? 0 : this.getJobDriver().hashCode());
        hashCode = 31 * hashCode + (this.getParameterConfiguration() == null ? 0 : this.getParameterConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getJobTags() == null ? 0 : this.getJobTags().hashCode());
        return hashCode;
    }

    public JobTemplateData clone() {
        try {
            return (JobTemplateData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobTemplateDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

