/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eventbridge.model.ConnectionBodyParameter;
import com.amazonaws.services.eventbridge.model.ConnectionHeaderParameter;
import com.amazonaws.services.eventbridge.model.ConnectionQueryStringParameter;
import com.amazonaws.services.eventbridge.model.transform.ConnectionHttpParametersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectionHttpParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ConnectionHeaderParameter> headerParameters;
    private List<ConnectionQueryStringParameter> queryStringParameters;
    private List<ConnectionBodyParameter> bodyParameters;

    public List<ConnectionHeaderParameter> getHeaderParameters() {
        return this.headerParameters;
    }

    public void setHeaderParameters(Collection<ConnectionHeaderParameter> headerParameters) {
        if (headerParameters == null) {
            this.headerParameters = null;
            return;
        }
        this.headerParameters = new ArrayList<ConnectionHeaderParameter>(headerParameters);
    }

    public ConnectionHttpParameters withHeaderParameters(ConnectionHeaderParameter ... headerParameters) {
        if (this.headerParameters == null) {
            this.setHeaderParameters(new ArrayList<ConnectionHeaderParameter>(headerParameters.length));
        }
        for (ConnectionHeaderParameter ele : headerParameters) {
            this.headerParameters.add(ele);
        }
        return this;
    }

    public ConnectionHttpParameters withHeaderParameters(Collection<ConnectionHeaderParameter> headerParameters) {
        this.setHeaderParameters(headerParameters);
        return this;
    }

    public List<ConnectionQueryStringParameter> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public void setQueryStringParameters(Collection<ConnectionQueryStringParameter> queryStringParameters) {
        if (queryStringParameters == null) {
            this.queryStringParameters = null;
            return;
        }
        this.queryStringParameters = new ArrayList<ConnectionQueryStringParameter>(queryStringParameters);
    }

    public ConnectionHttpParameters withQueryStringParameters(ConnectionQueryStringParameter ... queryStringParameters) {
        if (this.queryStringParameters == null) {
            this.setQueryStringParameters(new ArrayList<ConnectionQueryStringParameter>(queryStringParameters.length));
        }
        for (ConnectionQueryStringParameter ele : queryStringParameters) {
            this.queryStringParameters.add(ele);
        }
        return this;
    }

    public ConnectionHttpParameters withQueryStringParameters(Collection<ConnectionQueryStringParameter> queryStringParameters) {
        this.setQueryStringParameters(queryStringParameters);
        return this;
    }

    public List<ConnectionBodyParameter> getBodyParameters() {
        return this.bodyParameters;
    }

    public void setBodyParameters(Collection<ConnectionBodyParameter> bodyParameters) {
        if (bodyParameters == null) {
            this.bodyParameters = null;
            return;
        }
        this.bodyParameters = new ArrayList<ConnectionBodyParameter>(bodyParameters);
    }

    public ConnectionHttpParameters withBodyParameters(ConnectionBodyParameter ... bodyParameters) {
        if (this.bodyParameters == null) {
            this.setBodyParameters(new ArrayList<ConnectionBodyParameter>(bodyParameters.length));
        }
        for (ConnectionBodyParameter ele : bodyParameters) {
            this.bodyParameters.add(ele);
        }
        return this;
    }

    public ConnectionHttpParameters withBodyParameters(Collection<ConnectionBodyParameter> bodyParameters) {
        this.setBodyParameters(bodyParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHeaderParameters() != null) {
            sb.append("HeaderParameters: ").append(this.getHeaderParameters()).append(",");
        }
        if (this.getQueryStringParameters() != null) {
            sb.append("QueryStringParameters: ").append(this.getQueryStringParameters()).append(",");
        }
        if (this.getBodyParameters() != null) {
            sb.append("BodyParameters: ").append(this.getBodyParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionHttpParameters)) {
            return false;
        }
        ConnectionHttpParameters other = (ConnectionHttpParameters)obj;
        if (other.getHeaderParameters() == null ^ this.getHeaderParameters() == null) {
            return false;
        }
        if (other.getHeaderParameters() != null && !other.getHeaderParameters().equals(this.getHeaderParameters())) {
            return false;
        }
        if (other.getQueryStringParameters() == null ^ this.getQueryStringParameters() == null) {
            return false;
        }
        if (other.getQueryStringParameters() != null && !other.getQueryStringParameters().equals(this.getQueryStringParameters())) {
            return false;
        }
        if (other.getBodyParameters() == null ^ this.getBodyParameters() == null) {
            return false;
        }
        return other.getBodyParameters() == null || other.getBodyParameters().equals(this.getBodyParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHeaderParameters() == null ? 0 : this.getHeaderParameters().hashCode());
        hashCode = 31 * hashCode + (this.getQueryStringParameters() == null ? 0 : this.getQueryStringParameters().hashCode());
        hashCode = 31 * hashCode + (this.getBodyParameters() == null ? 0 : this.getBodyParameters().hashCode());
        return hashCode;
    }

    public ConnectionHttpParameters clone() {
        try {
            return (ConnectionHttpParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionHttpParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

