/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.finspace.model.KxEnvironment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListKxEnvironmentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<KxEnvironment> environments;
    private String nextToken;

    public List<KxEnvironment> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(Collection<KxEnvironment> environments) {
        if (environments == null) {
            this.environments = null;
            return;
        }
        this.environments = new ArrayList<KxEnvironment>(environments);
    }

    public ListKxEnvironmentsResult withEnvironments(KxEnvironment ... environments) {
        if (this.environments == null) {
            this.setEnvironments(new ArrayList<KxEnvironment>(environments.length));
        }
        for (KxEnvironment ele : environments) {
            this.environments.add(ele);
        }
        return this;
    }

    public ListKxEnvironmentsResult withEnvironments(Collection<KxEnvironment> environments) {
        this.setEnvironments(environments);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListKxEnvironmentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironments() != null) {
            sb.append("Environments: ").append(this.getEnvironments()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxEnvironmentsResult)) {
            return false;
        }
        ListKxEnvironmentsResult other = (ListKxEnvironmentsResult)obj;
        if (other.getEnvironments() == null ^ this.getEnvironments() == null) {
            return false;
        }
        if (other.getEnvironments() != null && !other.getEnvironments().equals(this.getEnvironments())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironments() == null ? 0 : this.getEnvironments().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListKxEnvironmentsResult clone() {
        try {
            return (ListKxEnvironmentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

