/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fis.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes the options for an experiment.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ExperimentOptions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ExperimentOptions implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The account targeting setting for an experiment.
     * </p>
     */
    private String accountTargeting;
    /**
     * <p>
     * The empty target resolution mode for an experiment.
     * </p>
     */
    private String emptyTargetResolutionMode;
    /**
     * <p>
     * The actions mode of the experiment that is set from the StartExperiment API command.
     * </p>
     */
    private String actionsMode;

    /**
     * <p>
     * The account targeting setting for an experiment.
     * </p>
     * 
     * @param accountTargeting
     *        The account targeting setting for an experiment.
     * @see AccountTargeting
     */

    public void setAccountTargeting(String accountTargeting) {
        this.accountTargeting = accountTargeting;
    }

    /**
     * <p>
     * The account targeting setting for an experiment.
     * </p>
     * 
     * @return The account targeting setting for an experiment.
     * @see AccountTargeting
     */

    public String getAccountTargeting() {
        return this.accountTargeting;
    }

    /**
     * <p>
     * The account targeting setting for an experiment.
     * </p>
     * 
     * @param accountTargeting
     *        The account targeting setting for an experiment.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AccountTargeting
     */

    public ExperimentOptions withAccountTargeting(String accountTargeting) {
        setAccountTargeting(accountTargeting);
        return this;
    }

    /**
     * <p>
     * The account targeting setting for an experiment.
     * </p>
     * 
     * @param accountTargeting
     *        The account targeting setting for an experiment.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AccountTargeting
     */

    public ExperimentOptions withAccountTargeting(AccountTargeting accountTargeting) {
        this.accountTargeting = accountTargeting.toString();
        return this;
    }

    /**
     * <p>
     * The empty target resolution mode for an experiment.
     * </p>
     * 
     * @param emptyTargetResolutionMode
     *        The empty target resolution mode for an experiment.
     * @see EmptyTargetResolutionMode
     */

    public void setEmptyTargetResolutionMode(String emptyTargetResolutionMode) {
        this.emptyTargetResolutionMode = emptyTargetResolutionMode;
    }

    /**
     * <p>
     * The empty target resolution mode for an experiment.
     * </p>
     * 
     * @return The empty target resolution mode for an experiment.
     * @see EmptyTargetResolutionMode
     */

    public String getEmptyTargetResolutionMode() {
        return this.emptyTargetResolutionMode;
    }

    /**
     * <p>
     * The empty target resolution mode for an experiment.
     * </p>
     * 
     * @param emptyTargetResolutionMode
     *        The empty target resolution mode for an experiment.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EmptyTargetResolutionMode
     */

    public ExperimentOptions withEmptyTargetResolutionMode(String emptyTargetResolutionMode) {
        setEmptyTargetResolutionMode(emptyTargetResolutionMode);
        return this;
    }

    /**
     * <p>
     * The empty target resolution mode for an experiment.
     * </p>
     * 
     * @param emptyTargetResolutionMode
     *        The empty target resolution mode for an experiment.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EmptyTargetResolutionMode
     */

    public ExperimentOptions withEmptyTargetResolutionMode(EmptyTargetResolutionMode emptyTargetResolutionMode) {
        this.emptyTargetResolutionMode = emptyTargetResolutionMode.toString();
        return this;
    }

    /**
     * <p>
     * The actions mode of the experiment that is set from the StartExperiment API command.
     * </p>
     * 
     * @param actionsMode
     *        The actions mode of the experiment that is set from the StartExperiment API command.
     * @see ActionsMode
     */

    public void setActionsMode(String actionsMode) {
        this.actionsMode = actionsMode;
    }

    /**
     * <p>
     * The actions mode of the experiment that is set from the StartExperiment API command.
     * </p>
     * 
     * @return The actions mode of the experiment that is set from the StartExperiment API command.
     * @see ActionsMode
     */

    public String getActionsMode() {
        return this.actionsMode;
    }

    /**
     * <p>
     * The actions mode of the experiment that is set from the StartExperiment API command.
     * </p>
     * 
     * @param actionsMode
     *        The actions mode of the experiment that is set from the StartExperiment API command.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ActionsMode
     */

    public ExperimentOptions withActionsMode(String actionsMode) {
        setActionsMode(actionsMode);
        return this;
    }

    /**
     * <p>
     * The actions mode of the experiment that is set from the StartExperiment API command.
     * </p>
     * 
     * @param actionsMode
     *        The actions mode of the experiment that is set from the StartExperiment API command.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ActionsMode
     */

    public ExperimentOptions withActionsMode(ActionsMode actionsMode) {
        this.actionsMode = actionsMode.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccountTargeting() != null)
            sb.append("AccountTargeting: ").append(getAccountTargeting()).append(",");
        if (getEmptyTargetResolutionMode() != null)
            sb.append("EmptyTargetResolutionMode: ").append(getEmptyTargetResolutionMode()).append(",");
        if (getActionsMode() != null)
            sb.append("ActionsMode: ").append(getActionsMode());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ExperimentOptions == false)
            return false;
        ExperimentOptions other = (ExperimentOptions) obj;
        if (other.getAccountTargeting() == null ^ this.getAccountTargeting() == null)
            return false;
        if (other.getAccountTargeting() != null && other.getAccountTargeting().equals(this.getAccountTargeting()) == false)
            return false;
        if (other.getEmptyTargetResolutionMode() == null ^ this.getEmptyTargetResolutionMode() == null)
            return false;
        if (other.getEmptyTargetResolutionMode() != null && other.getEmptyTargetResolutionMode().equals(this.getEmptyTargetResolutionMode()) == false)
            return false;
        if (other.getActionsMode() == null ^ this.getActionsMode() == null)
            return false;
        if (other.getActionsMode() != null && other.getActionsMode().equals(this.getActionsMode()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccountTargeting() == null) ? 0 : getAccountTargeting().hashCode());
        hashCode = prime * hashCode + ((getEmptyTargetResolutionMode() == null) ? 0 : getEmptyTargetResolutionMode().hashCode());
        hashCode = prime * hashCode + ((getActionsMode() == null) ? 0 : getActionsMode().hashCode());
        return hashCode;
    }

    @Override
    public ExperimentOptions clone() {
        try {
            return (ExperimentOptions) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.fis.model.transform.ExperimentOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
