/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.fms.AWSFMS;
import com.amazonaws.services.fms.AWSFMSClientBuilder;
import com.amazonaws.services.fms.model.AWSFMSException;
import com.amazonaws.services.fms.model.AssociateAdminAccountRequest;
import com.amazonaws.services.fms.model.AssociateAdminAccountResult;
import com.amazonaws.services.fms.model.DeleteNotificationChannelRequest;
import com.amazonaws.services.fms.model.DeleteNotificationChannelResult;
import com.amazonaws.services.fms.model.DeletePolicyRequest;
import com.amazonaws.services.fms.model.DeletePolicyResult;
import com.amazonaws.services.fms.model.DisassociateAdminAccountRequest;
import com.amazonaws.services.fms.model.DisassociateAdminAccountResult;
import com.amazonaws.services.fms.model.GetAdminAccountRequest;
import com.amazonaws.services.fms.model.GetAdminAccountResult;
import com.amazonaws.services.fms.model.GetComplianceDetailRequest;
import com.amazonaws.services.fms.model.GetComplianceDetailResult;
import com.amazonaws.services.fms.model.GetNotificationChannelRequest;
import com.amazonaws.services.fms.model.GetNotificationChannelResult;
import com.amazonaws.services.fms.model.GetPolicyRequest;
import com.amazonaws.services.fms.model.GetPolicyResult;
import com.amazonaws.services.fms.model.GetProtectionStatusRequest;
import com.amazonaws.services.fms.model.GetProtectionStatusResult;
import com.amazonaws.services.fms.model.ListComplianceStatusRequest;
import com.amazonaws.services.fms.model.ListComplianceStatusResult;
import com.amazonaws.services.fms.model.ListMemberAccountsRequest;
import com.amazonaws.services.fms.model.ListMemberAccountsResult;
import com.amazonaws.services.fms.model.ListPoliciesRequest;
import com.amazonaws.services.fms.model.ListPoliciesResult;
import com.amazonaws.services.fms.model.PutNotificationChannelRequest;
import com.amazonaws.services.fms.model.PutNotificationChannelResult;
import com.amazonaws.services.fms.model.PutPolicyRequest;
import com.amazonaws.services.fms.model.PutPolicyResult;
import com.amazonaws.services.fms.model.transform.AssociateAdminAccountRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.AssociateAdminAccountResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.DeleteNotificationChannelRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.DeleteNotificationChannelResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.DeletePolicyRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.DeletePolicyResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.DisassociateAdminAccountRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.DisassociateAdminAccountResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.GetAdminAccountRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.GetAdminAccountResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.GetComplianceDetailRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.GetComplianceDetailResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.GetNotificationChannelRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.GetNotificationChannelResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.GetPolicyRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.GetPolicyResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.GetProtectionStatusRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.GetProtectionStatusResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.services.fms.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.fms.model.transform.InvalidOperationExceptionUnmarshaller;
import com.amazonaws.services.fms.model.transform.InvalidTypeExceptionUnmarshaller;
import com.amazonaws.services.fms.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.fms.model.transform.ListComplianceStatusRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.ListComplianceStatusResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.ListMemberAccountsRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.ListMemberAccountsResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.ListPoliciesRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.ListPoliciesResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.PutNotificationChannelRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.PutNotificationChannelResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.PutPolicyRequestProtocolMarshaller;
import com.amazonaws.services.fms.model.transform.PutPolicyResultJsonUnmarshaller;
import com.amazonaws.services.fms.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSFMSClient
extends AmazonWebServiceClient
implements AWSFMS {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSFMS.class);
    private static final String DEFAULT_SIGNING_NAME = "fms";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidOperationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidOperationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidInputExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidTypeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidTypeExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSFMSException.class));

    public static AWSFMSClientBuilder builder() {
        return AWSFMSClientBuilder.standard();
    }

    AWSFMSClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSFMSClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("fms.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/fms/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/fms/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateAdminAccountResult associateAdminAccount(AssociateAdminAccountRequest request) {
        request = (AssociateAdminAccountRequest)this.beforeClientExecution(request);
        return this.executeAssociateAdminAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateAdminAccountResult executeAssociateAdminAccount(AssociateAdminAccountRequest associateAdminAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateAdminAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateAdminAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateAdminAccountRequestProtocolMarshaller(protocolFactory).marshall((AssociateAdminAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateAdminAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateAdminAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateAdminAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateAdminAccountResult associateAdminAccountResult = (AssociateAdminAccountResult)response.getAwsResponse();
            return associateAdminAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteNotificationChannelResult deleteNotificationChannel(DeleteNotificationChannelRequest request) {
        request = (DeleteNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteNotificationChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteNotificationChannelResult executeDeleteNotificationChannel(DeleteNotificationChannelRequest deleteNotificationChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteNotificationChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteNotificationChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteNotificationChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteNotificationChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteNotificationChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteNotificationChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteNotificationChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteNotificationChannelResult deleteNotificationChannelResult = (DeleteNotificationChannelResult)response.getAwsResponse();
            return deleteNotificationChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePolicyResult deletePolicy(DeletePolicyRequest request) {
        request = (DeletePolicyRequest)this.beforeClientExecution(request);
        return this.executeDeletePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePolicyResult executeDeletePolicy(DeletePolicyRequest deletePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePolicyRequestProtocolMarshaller(protocolFactory).marshall((DeletePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePolicyResult deletePolicyResult = (DeletePolicyResult)response.getAwsResponse();
            return deletePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateAdminAccountResult disassociateAdminAccount(DisassociateAdminAccountRequest request) {
        request = (DisassociateAdminAccountRequest)this.beforeClientExecution(request);
        return this.executeDisassociateAdminAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateAdminAccountResult executeDisassociateAdminAccount(DisassociateAdminAccountRequest disassociateAdminAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateAdminAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateAdminAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateAdminAccountRequestProtocolMarshaller(protocolFactory).marshall((DisassociateAdminAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateAdminAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateAdminAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateAdminAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateAdminAccountResult disassociateAdminAccountResult = (DisassociateAdminAccountResult)response.getAwsResponse();
            return disassociateAdminAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAdminAccountResult getAdminAccount(GetAdminAccountRequest request) {
        request = (GetAdminAccountRequest)this.beforeClientExecution(request);
        return this.executeGetAdminAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAdminAccountResult executeGetAdminAccount(GetAdminAccountRequest getAdminAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAdminAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAdminAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAdminAccountRequestProtocolMarshaller(protocolFactory).marshall((GetAdminAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAdminAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAdminAccount");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAdminAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAdminAccountResult getAdminAccountResult = (GetAdminAccountResult)response.getAwsResponse();
            return getAdminAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetComplianceDetailResult getComplianceDetail(GetComplianceDetailRequest request) {
        request = (GetComplianceDetailRequest)this.beforeClientExecution(request);
        return this.executeGetComplianceDetail(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetComplianceDetailResult executeGetComplianceDetail(GetComplianceDetailRequest getComplianceDetailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceDetailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceDetailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceDetailRequestProtocolMarshaller(protocolFactory).marshall((GetComplianceDetailRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComplianceDetailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetComplianceDetail");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComplianceDetailResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetComplianceDetailResult getComplianceDetailResult = (GetComplianceDetailResult)response.getAwsResponse();
            return getComplianceDetailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetNotificationChannelResult getNotificationChannel(GetNotificationChannelRequest request) {
        request = (GetNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executeGetNotificationChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetNotificationChannelResult executeGetNotificationChannel(GetNotificationChannelRequest getNotificationChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getNotificationChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetNotificationChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetNotificationChannelRequestProtocolMarshaller(protocolFactory).marshall((GetNotificationChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)getNotificationChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetNotificationChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetNotificationChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetNotificationChannelResult getNotificationChannelResult = (GetNotificationChannelResult)response.getAwsResponse();
            return getNotificationChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest request) {
        request = (GetPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPolicyResult executeGetPolicy(GetPolicyRequest getPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPolicyResult getPolicyResult = (GetPolicyResult)response.getAwsResponse();
            return getPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProtectionStatusResult getProtectionStatus(GetProtectionStatusRequest request) {
        request = (GetProtectionStatusRequest)this.beforeClientExecution(request);
        return this.executeGetProtectionStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProtectionStatusResult executeGetProtectionStatus(GetProtectionStatusRequest getProtectionStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProtectionStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProtectionStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProtectionStatusRequestProtocolMarshaller(protocolFactory).marshall((GetProtectionStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProtectionStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProtectionStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProtectionStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProtectionStatusResult getProtectionStatusResult = (GetProtectionStatusResult)response.getAwsResponse();
            return getProtectionStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListComplianceStatusResult listComplianceStatus(ListComplianceStatusRequest request) {
        request = (ListComplianceStatusRequest)this.beforeClientExecution(request);
        return this.executeListComplianceStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListComplianceStatusResult executeListComplianceStatus(ListComplianceStatusRequest listComplianceStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listComplianceStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListComplianceStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListComplianceStatusRequestProtocolMarshaller(protocolFactory).marshall((ListComplianceStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)listComplianceStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListComplianceStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListComplianceStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListComplianceStatusResult listComplianceStatusResult = (ListComplianceStatusResult)response.getAwsResponse();
            return listComplianceStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMemberAccountsResult listMemberAccounts(ListMemberAccountsRequest request) {
        request = (ListMemberAccountsRequest)this.beforeClientExecution(request);
        return this.executeListMemberAccounts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMemberAccountsResult executeListMemberAccounts(ListMemberAccountsRequest listMemberAccountsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMemberAccountsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMemberAccountsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMemberAccountsRequestProtocolMarshaller(protocolFactory).marshall((ListMemberAccountsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMemberAccountsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMemberAccounts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMemberAccountsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMemberAccountsResult listMemberAccountsResult = (ListMemberAccountsResult)response.getAwsResponse();
            return listMemberAccountsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPoliciesResult listPolicies(ListPoliciesRequest request) {
        request = (ListPoliciesRequest)this.beforeClientExecution(request);
        return this.executeListPolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPoliciesResult executeListPolicies(ListPoliciesRequest listPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPoliciesRequestProtocolMarshaller(protocolFactory).marshall((ListPoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPolicies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPoliciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPoliciesResult listPoliciesResult = (ListPoliciesResult)response.getAwsResponse();
            return listPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutNotificationChannelResult putNotificationChannel(PutNotificationChannelRequest request) {
        request = (PutNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executePutNotificationChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutNotificationChannelResult executePutNotificationChannel(PutNotificationChannelRequest putNotificationChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putNotificationChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutNotificationChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutNotificationChannelRequestProtocolMarshaller(protocolFactory).marshall((PutNotificationChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)putNotificationChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutNotificationChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutNotificationChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutNotificationChannelResult putNotificationChannelResult = (PutNotificationChannelResult)response.getAwsResponse();
            return putNotificationChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutPolicyResult putPolicy(PutPolicyRequest request) {
        request = (PutPolicyRequest)this.beforeClientExecution(request);
        return this.executePutPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutPolicyResult executePutPolicy(PutPolicyRequest putPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FMS");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutPolicyResult putPolicyResult = (PutPolicyResult)response.getAwsResponse();
            return putPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

