/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.App;
import com.amazonaws.services.fms.model.transform.AppsListDataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppsListData
implements Serializable,
Cloneable,
StructuredPojo {
    private String listId;
    private String listName;
    private String listUpdateToken;
    private Date createTime;
    private Date lastUpdateTime;
    private List<App> appsList;
    private Map<String, List<App>> previousAppsList;

    public void setListId(String listId) {
        this.listId = listId;
    }

    public String getListId() {
        return this.listId;
    }

    public AppsListData withListId(String listId) {
        this.setListId(listId);
        return this;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public String getListName() {
        return this.listName;
    }

    public AppsListData withListName(String listName) {
        this.setListName(listName);
        return this;
    }

    public void setListUpdateToken(String listUpdateToken) {
        this.listUpdateToken = listUpdateToken;
    }

    public String getListUpdateToken() {
        return this.listUpdateToken;
    }

    public AppsListData withListUpdateToken(String listUpdateToken) {
        this.setListUpdateToken(listUpdateToken);
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public AppsListData withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public AppsListData withLastUpdateTime(Date lastUpdateTime) {
        this.setLastUpdateTime(lastUpdateTime);
        return this;
    }

    public List<App> getAppsList() {
        return this.appsList;
    }

    public void setAppsList(Collection<App> appsList) {
        if (appsList == null) {
            this.appsList = null;
            return;
        }
        this.appsList = new ArrayList<App>(appsList);
    }

    public AppsListData withAppsList(App ... appsList) {
        if (this.appsList == null) {
            this.setAppsList(new ArrayList<App>(appsList.length));
        }
        for (App ele : appsList) {
            this.appsList.add(ele);
        }
        return this;
    }

    public AppsListData withAppsList(Collection<App> appsList) {
        this.setAppsList(appsList);
        return this;
    }

    public Map<String, List<App>> getPreviousAppsList() {
        return this.previousAppsList;
    }

    public void setPreviousAppsList(Map<String, List<App>> previousAppsList) {
        this.previousAppsList = previousAppsList;
    }

    public AppsListData withPreviousAppsList(Map<String, List<App>> previousAppsList) {
        this.setPreviousAppsList(previousAppsList);
        return this;
    }

    public AppsListData addPreviousAppsListEntry(String key, List<App> value) {
        if (null == this.previousAppsList) {
            this.previousAppsList = new HashMap<String, List<App>>();
        }
        if (this.previousAppsList.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.previousAppsList.put(key, value);
        return this;
    }

    public AppsListData clearPreviousAppsListEntries() {
        this.previousAppsList = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getListId() != null) {
            sb.append("ListId: ").append(this.getListId()).append(",");
        }
        if (this.getListName() != null) {
            sb.append("ListName: ").append(this.getListName()).append(",");
        }
        if (this.getListUpdateToken() != null) {
            sb.append("ListUpdateToken: ").append(this.getListUpdateToken()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getLastUpdateTime() != null) {
            sb.append("LastUpdateTime: ").append(this.getLastUpdateTime()).append(",");
        }
        if (this.getAppsList() != null) {
            sb.append("AppsList: ").append(this.getAppsList()).append(",");
        }
        if (this.getPreviousAppsList() != null) {
            sb.append("PreviousAppsList: ").append(this.getPreviousAppsList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppsListData)) {
            return false;
        }
        AppsListData other = (AppsListData)obj;
        if (other.getListId() == null ^ this.getListId() == null) {
            return false;
        }
        if (other.getListId() != null && !other.getListId().equals(this.getListId())) {
            return false;
        }
        if (other.getListName() == null ^ this.getListName() == null) {
            return false;
        }
        if (other.getListName() != null && !other.getListName().equals(this.getListName())) {
            return false;
        }
        if (other.getListUpdateToken() == null ^ this.getListUpdateToken() == null) {
            return false;
        }
        if (other.getListUpdateToken() != null && !other.getListUpdateToken().equals(this.getListUpdateToken())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getLastUpdateTime() == null ^ this.getLastUpdateTime() == null) {
            return false;
        }
        if (other.getLastUpdateTime() != null && !other.getLastUpdateTime().equals(this.getLastUpdateTime())) {
            return false;
        }
        if (other.getAppsList() == null ^ this.getAppsList() == null) {
            return false;
        }
        if (other.getAppsList() != null && !other.getAppsList().equals(this.getAppsList())) {
            return false;
        }
        if (other.getPreviousAppsList() == null ^ this.getPreviousAppsList() == null) {
            return false;
        }
        return other.getPreviousAppsList() == null || other.getPreviousAppsList().equals(this.getPreviousAppsList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getListId() == null ? 0 : this.getListId().hashCode());
        hashCode = 31 * hashCode + (this.getListName() == null ? 0 : this.getListName().hashCode());
        hashCode = 31 * hashCode + (this.getListUpdateToken() == null ? 0 : this.getListUpdateToken().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateTime() == null ? 0 : this.getLastUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getAppsList() == null ? 0 : this.getAppsList().hashCode());
        hashCode = 31 * hashCode + (this.getPreviousAppsList() == null ? 0 : this.getPreviousAppsList().hashCode());
        return hashCode;
    }

    public AppsListData clone() {
        try {
            return (AppsListData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppsListDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

