/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.fms.model.ResourceSetSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListResourceSetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ResourceSetSummary> resourceSets;
    private String nextToken;

    public List<ResourceSetSummary> getResourceSets() {
        return this.resourceSets;
    }

    public void setResourceSets(Collection<ResourceSetSummary> resourceSets) {
        if (resourceSets == null) {
            this.resourceSets = null;
            return;
        }
        this.resourceSets = new ArrayList<ResourceSetSummary>(resourceSets);
    }

    public ListResourceSetsResult withResourceSets(ResourceSetSummary ... resourceSets) {
        if (this.resourceSets == null) {
            this.setResourceSets(new ArrayList<ResourceSetSummary>(resourceSets.length));
        }
        for (ResourceSetSummary ele : resourceSets) {
            this.resourceSets.add(ele);
        }
        return this;
    }

    public ListResourceSetsResult withResourceSets(Collection<ResourceSetSummary> resourceSets) {
        this.setResourceSets(resourceSets);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListResourceSetsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceSets() != null) {
            sb.append("ResourceSets: ").append(this.getResourceSets()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceSetsResult)) {
            return false;
        }
        ListResourceSetsResult other = (ListResourceSetsResult)obj;
        if (other.getResourceSets() == null ^ this.getResourceSets() == null) {
            return false;
        }
        if (other.getResourceSets() != null && !other.getResourceSets().equals(this.getResourceSets())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceSets() == null ? 0 : this.getResourceSets().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListResourceSetsResult clone() {
        try {
            return (ListResourceSetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

