/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.SupplementaryFeature;
import com.amazonaws.services.forecast.model.transform.InputDataConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InputDataConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String datasetGroupArn;
    private List<SupplementaryFeature> supplementaryFeatures;

    public void setDatasetGroupArn(String datasetGroupArn) {
        this.datasetGroupArn = datasetGroupArn;
    }

    public String getDatasetGroupArn() {
        return this.datasetGroupArn;
    }

    public InputDataConfig withDatasetGroupArn(String datasetGroupArn) {
        this.setDatasetGroupArn(datasetGroupArn);
        return this;
    }

    public List<SupplementaryFeature> getSupplementaryFeatures() {
        return this.supplementaryFeatures;
    }

    public void setSupplementaryFeatures(Collection<SupplementaryFeature> supplementaryFeatures) {
        if (supplementaryFeatures == null) {
            this.supplementaryFeatures = null;
            return;
        }
        this.supplementaryFeatures = new ArrayList<SupplementaryFeature>(supplementaryFeatures);
    }

    public InputDataConfig withSupplementaryFeatures(SupplementaryFeature ... supplementaryFeatures) {
        if (this.supplementaryFeatures == null) {
            this.setSupplementaryFeatures(new ArrayList<SupplementaryFeature>(supplementaryFeatures.length));
        }
        for (SupplementaryFeature ele : supplementaryFeatures) {
            this.supplementaryFeatures.add(ele);
        }
        return this;
    }

    public InputDataConfig withSupplementaryFeatures(Collection<SupplementaryFeature> supplementaryFeatures) {
        this.setSupplementaryFeatures(supplementaryFeatures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasetGroupArn() != null) {
            sb.append("DatasetGroupArn: ").append(this.getDatasetGroupArn()).append(",");
        }
        if (this.getSupplementaryFeatures() != null) {
            sb.append("SupplementaryFeatures: ").append(this.getSupplementaryFeatures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig)obj;
        if (other.getDatasetGroupArn() == null ^ this.getDatasetGroupArn() == null) {
            return false;
        }
        if (other.getDatasetGroupArn() != null && !other.getDatasetGroupArn().equals(this.getDatasetGroupArn())) {
            return false;
        }
        if (other.getSupplementaryFeatures() == null ^ this.getSupplementaryFeatures() == null) {
            return false;
        }
        return other.getSupplementaryFeatures() == null || other.getSupplementaryFeatures().equals(this.getSupplementaryFeatures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasetGroupArn() == null ? 0 : this.getDatasetGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getSupplementaryFeatures() == null ? 0 : this.getSupplementaryFeatures().hashCode());
        return hashCode;
    }

    public InputDataConfig clone() {
        try {
            return (InputDataConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDataConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

