/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.frauddetector.AmazonFraudDetectorAsync;
import com.amazonaws.services.frauddetector.AmazonFraudDetectorAsyncClientBuilder;
import com.amazonaws.services.frauddetector.AmazonFraudDetectorClient;
import com.amazonaws.services.frauddetector.model.BatchCreateVariableRequest;
import com.amazonaws.services.frauddetector.model.BatchCreateVariableResult;
import com.amazonaws.services.frauddetector.model.BatchGetVariableRequest;
import com.amazonaws.services.frauddetector.model.BatchGetVariableResult;
import com.amazonaws.services.frauddetector.model.CreateDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.CreateDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.CreateModelRequest;
import com.amazonaws.services.frauddetector.model.CreateModelResult;
import com.amazonaws.services.frauddetector.model.CreateModelVersionRequest;
import com.amazonaws.services.frauddetector.model.CreateModelVersionResult;
import com.amazonaws.services.frauddetector.model.CreateRuleRequest;
import com.amazonaws.services.frauddetector.model.CreateRuleResult;
import com.amazonaws.services.frauddetector.model.CreateVariableRequest;
import com.amazonaws.services.frauddetector.model.CreateVariableResult;
import com.amazonaws.services.frauddetector.model.DeleteDetectorRequest;
import com.amazonaws.services.frauddetector.model.DeleteDetectorResult;
import com.amazonaws.services.frauddetector.model.DeleteDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.DeleteDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.DeleteEventRequest;
import com.amazonaws.services.frauddetector.model.DeleteEventResult;
import com.amazonaws.services.frauddetector.model.DeleteRuleRequest;
import com.amazonaws.services.frauddetector.model.DeleteRuleResult;
import com.amazonaws.services.frauddetector.model.DescribeDetectorRequest;
import com.amazonaws.services.frauddetector.model.DescribeDetectorResult;
import com.amazonaws.services.frauddetector.model.DescribeModelVersionsRequest;
import com.amazonaws.services.frauddetector.model.DescribeModelVersionsResult;
import com.amazonaws.services.frauddetector.model.GetDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.GetDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.GetDetectorsRequest;
import com.amazonaws.services.frauddetector.model.GetDetectorsResult;
import com.amazonaws.services.frauddetector.model.GetEntityTypesRequest;
import com.amazonaws.services.frauddetector.model.GetEntityTypesResult;
import com.amazonaws.services.frauddetector.model.GetEventPredictionRequest;
import com.amazonaws.services.frauddetector.model.GetEventPredictionResult;
import com.amazonaws.services.frauddetector.model.GetEventTypesRequest;
import com.amazonaws.services.frauddetector.model.GetEventTypesResult;
import com.amazonaws.services.frauddetector.model.GetExternalModelsRequest;
import com.amazonaws.services.frauddetector.model.GetExternalModelsResult;
import com.amazonaws.services.frauddetector.model.GetKMSEncryptionKeyRequest;
import com.amazonaws.services.frauddetector.model.GetKMSEncryptionKeyResult;
import com.amazonaws.services.frauddetector.model.GetLabelsRequest;
import com.amazonaws.services.frauddetector.model.GetLabelsResult;
import com.amazonaws.services.frauddetector.model.GetModelVersionRequest;
import com.amazonaws.services.frauddetector.model.GetModelVersionResult;
import com.amazonaws.services.frauddetector.model.GetModelsRequest;
import com.amazonaws.services.frauddetector.model.GetModelsResult;
import com.amazonaws.services.frauddetector.model.GetOutcomesRequest;
import com.amazonaws.services.frauddetector.model.GetOutcomesResult;
import com.amazonaws.services.frauddetector.model.GetRulesRequest;
import com.amazonaws.services.frauddetector.model.GetRulesResult;
import com.amazonaws.services.frauddetector.model.GetVariablesRequest;
import com.amazonaws.services.frauddetector.model.GetVariablesResult;
import com.amazonaws.services.frauddetector.model.ListTagsForResourceRequest;
import com.amazonaws.services.frauddetector.model.ListTagsForResourceResult;
import com.amazonaws.services.frauddetector.model.PutDetectorRequest;
import com.amazonaws.services.frauddetector.model.PutDetectorResult;
import com.amazonaws.services.frauddetector.model.PutEntityTypeRequest;
import com.amazonaws.services.frauddetector.model.PutEntityTypeResult;
import com.amazonaws.services.frauddetector.model.PutEventTypeRequest;
import com.amazonaws.services.frauddetector.model.PutEventTypeResult;
import com.amazonaws.services.frauddetector.model.PutExternalModelRequest;
import com.amazonaws.services.frauddetector.model.PutExternalModelResult;
import com.amazonaws.services.frauddetector.model.PutKMSEncryptionKeyRequest;
import com.amazonaws.services.frauddetector.model.PutKMSEncryptionKeyResult;
import com.amazonaws.services.frauddetector.model.PutLabelRequest;
import com.amazonaws.services.frauddetector.model.PutLabelResult;
import com.amazonaws.services.frauddetector.model.PutOutcomeRequest;
import com.amazonaws.services.frauddetector.model.PutOutcomeResult;
import com.amazonaws.services.frauddetector.model.TagResourceRequest;
import com.amazonaws.services.frauddetector.model.TagResourceResult;
import com.amazonaws.services.frauddetector.model.UntagResourceRequest;
import com.amazonaws.services.frauddetector.model.UntagResourceResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionMetadataResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionStatusResult;
import com.amazonaws.services.frauddetector.model.UpdateModelRequest;
import com.amazonaws.services.frauddetector.model.UpdateModelResult;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionStatusRequest;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionStatusResult;
import com.amazonaws.services.frauddetector.model.UpdateRuleMetadataRequest;
import com.amazonaws.services.frauddetector.model.UpdateRuleMetadataResult;
import com.amazonaws.services.frauddetector.model.UpdateRuleVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateRuleVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateVariableRequest;
import com.amazonaws.services.frauddetector.model.UpdateVariableResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonFraudDetectorAsyncClient
extends AmazonFraudDetectorClient
implements AmazonFraudDetectorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonFraudDetectorAsyncClientBuilder asyncBuilder() {
        return AmazonFraudDetectorAsyncClientBuilder.standard();
    }

    AmazonFraudDetectorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonFraudDetectorAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchCreateVariableResult> batchCreateVariableAsync(BatchCreateVariableRequest request) {
        return this.batchCreateVariableAsync(request, null);
    }

    @Override
    public Future<BatchCreateVariableResult> batchCreateVariableAsync(BatchCreateVariableRequest request, final AsyncHandler<BatchCreateVariableRequest, BatchCreateVariableResult> asyncHandler) {
        final BatchCreateVariableRequest finalRequest = (BatchCreateVariableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchCreateVariableResult>(){

            @Override
            public BatchCreateVariableResult call() throws Exception {
                BatchCreateVariableResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeBatchCreateVariable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetVariableResult> batchGetVariableAsync(BatchGetVariableRequest request) {
        return this.batchGetVariableAsync(request, null);
    }

    @Override
    public Future<BatchGetVariableResult> batchGetVariableAsync(BatchGetVariableRequest request, final AsyncHandler<BatchGetVariableRequest, BatchGetVariableResult> asyncHandler) {
        final BatchGetVariableRequest finalRequest = (BatchGetVariableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetVariableResult>(){

            @Override
            public BatchGetVariableResult call() throws Exception {
                BatchGetVariableResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeBatchGetVariable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDetectorVersionResult> createDetectorVersionAsync(CreateDetectorVersionRequest request) {
        return this.createDetectorVersionAsync(request, null);
    }

    @Override
    public Future<CreateDetectorVersionResult> createDetectorVersionAsync(CreateDetectorVersionRequest request, final AsyncHandler<CreateDetectorVersionRequest, CreateDetectorVersionResult> asyncHandler) {
        final CreateDetectorVersionRequest finalRequest = (CreateDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDetectorVersionResult>(){

            @Override
            public CreateDetectorVersionResult call() throws Exception {
                CreateDetectorVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateDetectorVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateModelResult> createModelAsync(CreateModelRequest request) {
        return this.createModelAsync(request, null);
    }

    @Override
    public Future<CreateModelResult> createModelAsync(CreateModelRequest request, final AsyncHandler<CreateModelRequest, CreateModelResult> asyncHandler) {
        final CreateModelRequest finalRequest = (CreateModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateModelResult>(){

            @Override
            public CreateModelResult call() throws Exception {
                CreateModelResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateModelVersionResult> createModelVersionAsync(CreateModelVersionRequest request) {
        return this.createModelVersionAsync(request, null);
    }

    @Override
    public Future<CreateModelVersionResult> createModelVersionAsync(CreateModelVersionRequest request, final AsyncHandler<CreateModelVersionRequest, CreateModelVersionResult> asyncHandler) {
        final CreateModelVersionRequest finalRequest = (CreateModelVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateModelVersionResult>(){

            @Override
            public CreateModelVersionResult call() throws Exception {
                CreateModelVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateModelVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request) {
        return this.createRuleAsync(request, null);
    }

    @Override
    public Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request, final AsyncHandler<CreateRuleRequest, CreateRuleResult> asyncHandler) {
        final CreateRuleRequest finalRequest = (CreateRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRuleResult>(){

            @Override
            public CreateRuleResult call() throws Exception {
                CreateRuleResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVariableResult> createVariableAsync(CreateVariableRequest request) {
        return this.createVariableAsync(request, null);
    }

    @Override
    public Future<CreateVariableResult> createVariableAsync(CreateVariableRequest request, final AsyncHandler<CreateVariableRequest, CreateVariableResult> asyncHandler) {
        final CreateVariableRequest finalRequest = (CreateVariableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVariableResult>(){

            @Override
            public CreateVariableResult call() throws Exception {
                CreateVariableResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeCreateVariable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDetectorResult> deleteDetectorAsync(DeleteDetectorRequest request) {
        return this.deleteDetectorAsync(request, null);
    }

    @Override
    public Future<DeleteDetectorResult> deleteDetectorAsync(DeleteDetectorRequest request, final AsyncHandler<DeleteDetectorRequest, DeleteDetectorResult> asyncHandler) {
        final DeleteDetectorRequest finalRequest = (DeleteDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDetectorResult>(){

            @Override
            public DeleteDetectorResult call() throws Exception {
                DeleteDetectorResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDeleteDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDetectorVersionResult> deleteDetectorVersionAsync(DeleteDetectorVersionRequest request) {
        return this.deleteDetectorVersionAsync(request, null);
    }

    @Override
    public Future<DeleteDetectorVersionResult> deleteDetectorVersionAsync(DeleteDetectorVersionRequest request, final AsyncHandler<DeleteDetectorVersionRequest, DeleteDetectorVersionResult> asyncHandler) {
        final DeleteDetectorVersionRequest finalRequest = (DeleteDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDetectorVersionResult>(){

            @Override
            public DeleteDetectorVersionResult call() throws Exception {
                DeleteDetectorVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDeleteDetectorVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEventResult> deleteEventAsync(DeleteEventRequest request) {
        return this.deleteEventAsync(request, null);
    }

    @Override
    public Future<DeleteEventResult> deleteEventAsync(DeleteEventRequest request, final AsyncHandler<DeleteEventRequest, DeleteEventResult> asyncHandler) {
        final DeleteEventRequest finalRequest = (DeleteEventRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEventResult>(){

            @Override
            public DeleteEventResult call() throws Exception {
                DeleteEventResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDeleteEvent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request) {
        return this.deleteRuleAsync(request, null);
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request, final AsyncHandler<DeleteRuleRequest, DeleteRuleResult> asyncHandler) {
        final DeleteRuleRequest finalRequest = (DeleteRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRuleResult>(){

            @Override
            public DeleteRuleResult call() throws Exception {
                DeleteRuleResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDeleteRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDetectorResult> describeDetectorAsync(DescribeDetectorRequest request) {
        return this.describeDetectorAsync(request, null);
    }

    @Override
    public Future<DescribeDetectorResult> describeDetectorAsync(DescribeDetectorRequest request, final AsyncHandler<DescribeDetectorRequest, DescribeDetectorResult> asyncHandler) {
        final DescribeDetectorRequest finalRequest = (DescribeDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDetectorResult>(){

            @Override
            public DescribeDetectorResult call() throws Exception {
                DescribeDetectorResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDescribeDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeModelVersionsResult> describeModelVersionsAsync(DescribeModelVersionsRequest request) {
        return this.describeModelVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeModelVersionsResult> describeModelVersionsAsync(DescribeModelVersionsRequest request, final AsyncHandler<DescribeModelVersionsRequest, DescribeModelVersionsResult> asyncHandler) {
        final DescribeModelVersionsRequest finalRequest = (DescribeModelVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeModelVersionsResult>(){

            @Override
            public DescribeModelVersionsResult call() throws Exception {
                DescribeModelVersionsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeDescribeModelVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDetectorVersionResult> getDetectorVersionAsync(GetDetectorVersionRequest request) {
        return this.getDetectorVersionAsync(request, null);
    }

    @Override
    public Future<GetDetectorVersionResult> getDetectorVersionAsync(GetDetectorVersionRequest request, final AsyncHandler<GetDetectorVersionRequest, GetDetectorVersionResult> asyncHandler) {
        final GetDetectorVersionRequest finalRequest = (GetDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDetectorVersionResult>(){

            @Override
            public GetDetectorVersionResult call() throws Exception {
                GetDetectorVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetDetectorVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDetectorsResult> getDetectorsAsync(GetDetectorsRequest request) {
        return this.getDetectorsAsync(request, null);
    }

    @Override
    public Future<GetDetectorsResult> getDetectorsAsync(GetDetectorsRequest request, final AsyncHandler<GetDetectorsRequest, GetDetectorsResult> asyncHandler) {
        final GetDetectorsRequest finalRequest = (GetDetectorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDetectorsResult>(){

            @Override
            public GetDetectorsResult call() throws Exception {
                GetDetectorsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetDetectors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEntityTypesResult> getEntityTypesAsync(GetEntityTypesRequest request) {
        return this.getEntityTypesAsync(request, null);
    }

    @Override
    public Future<GetEntityTypesResult> getEntityTypesAsync(GetEntityTypesRequest request, final AsyncHandler<GetEntityTypesRequest, GetEntityTypesResult> asyncHandler) {
        final GetEntityTypesRequest finalRequest = (GetEntityTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEntityTypesResult>(){

            @Override
            public GetEntityTypesResult call() throws Exception {
                GetEntityTypesResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetEntityTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEventPredictionResult> getEventPredictionAsync(GetEventPredictionRequest request) {
        return this.getEventPredictionAsync(request, null);
    }

    @Override
    public Future<GetEventPredictionResult> getEventPredictionAsync(GetEventPredictionRequest request, final AsyncHandler<GetEventPredictionRequest, GetEventPredictionResult> asyncHandler) {
        final GetEventPredictionRequest finalRequest = (GetEventPredictionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEventPredictionResult>(){

            @Override
            public GetEventPredictionResult call() throws Exception {
                GetEventPredictionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetEventPrediction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEventTypesResult> getEventTypesAsync(GetEventTypesRequest request) {
        return this.getEventTypesAsync(request, null);
    }

    @Override
    public Future<GetEventTypesResult> getEventTypesAsync(GetEventTypesRequest request, final AsyncHandler<GetEventTypesRequest, GetEventTypesResult> asyncHandler) {
        final GetEventTypesRequest finalRequest = (GetEventTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEventTypesResult>(){

            @Override
            public GetEventTypesResult call() throws Exception {
                GetEventTypesResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetEventTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExternalModelsResult> getExternalModelsAsync(GetExternalModelsRequest request) {
        return this.getExternalModelsAsync(request, null);
    }

    @Override
    public Future<GetExternalModelsResult> getExternalModelsAsync(GetExternalModelsRequest request, final AsyncHandler<GetExternalModelsRequest, GetExternalModelsResult> asyncHandler) {
        final GetExternalModelsRequest finalRequest = (GetExternalModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExternalModelsResult>(){

            @Override
            public GetExternalModelsResult call() throws Exception {
                GetExternalModelsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetExternalModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetKMSEncryptionKeyResult> getKMSEncryptionKeyAsync(GetKMSEncryptionKeyRequest request) {
        return this.getKMSEncryptionKeyAsync(request, null);
    }

    @Override
    public Future<GetKMSEncryptionKeyResult> getKMSEncryptionKeyAsync(GetKMSEncryptionKeyRequest request, final AsyncHandler<GetKMSEncryptionKeyRequest, GetKMSEncryptionKeyResult> asyncHandler) {
        final GetKMSEncryptionKeyRequest finalRequest = (GetKMSEncryptionKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetKMSEncryptionKeyResult>(){

            @Override
            public GetKMSEncryptionKeyResult call() throws Exception {
                GetKMSEncryptionKeyResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetKMSEncryptionKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLabelsResult> getLabelsAsync(GetLabelsRequest request) {
        return this.getLabelsAsync(request, null);
    }

    @Override
    public Future<GetLabelsResult> getLabelsAsync(GetLabelsRequest request, final AsyncHandler<GetLabelsRequest, GetLabelsResult> asyncHandler) {
        final GetLabelsRequest finalRequest = (GetLabelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLabelsResult>(){

            @Override
            public GetLabelsResult call() throws Exception {
                GetLabelsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetLabels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetModelVersionResult> getModelVersionAsync(GetModelVersionRequest request) {
        return this.getModelVersionAsync(request, null);
    }

    @Override
    public Future<GetModelVersionResult> getModelVersionAsync(GetModelVersionRequest request, final AsyncHandler<GetModelVersionRequest, GetModelVersionResult> asyncHandler) {
        final GetModelVersionRequest finalRequest = (GetModelVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetModelVersionResult>(){

            @Override
            public GetModelVersionResult call() throws Exception {
                GetModelVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetModelVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetModelsResult> getModelsAsync(GetModelsRequest request) {
        return this.getModelsAsync(request, null);
    }

    @Override
    public Future<GetModelsResult> getModelsAsync(GetModelsRequest request, final AsyncHandler<GetModelsRequest, GetModelsResult> asyncHandler) {
        final GetModelsRequest finalRequest = (GetModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetModelsResult>(){

            @Override
            public GetModelsResult call() throws Exception {
                GetModelsResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOutcomesResult> getOutcomesAsync(GetOutcomesRequest request) {
        return this.getOutcomesAsync(request, null);
    }

    @Override
    public Future<GetOutcomesResult> getOutcomesAsync(GetOutcomesRequest request, final AsyncHandler<GetOutcomesRequest, GetOutcomesResult> asyncHandler) {
        final GetOutcomesRequest finalRequest = (GetOutcomesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOutcomesResult>(){

            @Override
            public GetOutcomesResult call() throws Exception {
                GetOutcomesResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetOutcomes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRulesResult> getRulesAsync(GetRulesRequest request) {
        return this.getRulesAsync(request, null);
    }

    @Override
    public Future<GetRulesResult> getRulesAsync(GetRulesRequest request, final AsyncHandler<GetRulesRequest, GetRulesResult> asyncHandler) {
        final GetRulesRequest finalRequest = (GetRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRulesResult>(){

            @Override
            public GetRulesResult call() throws Exception {
                GetRulesResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetVariablesResult> getVariablesAsync(GetVariablesRequest request) {
        return this.getVariablesAsync(request, null);
    }

    @Override
    public Future<GetVariablesResult> getVariablesAsync(GetVariablesRequest request, final AsyncHandler<GetVariablesRequest, GetVariablesResult> asyncHandler) {
        final GetVariablesRequest finalRequest = (GetVariablesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetVariablesResult>(){

            @Override
            public GetVariablesResult call() throws Exception {
                GetVariablesResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeGetVariables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDetectorResult> putDetectorAsync(PutDetectorRequest request) {
        return this.putDetectorAsync(request, null);
    }

    @Override
    public Future<PutDetectorResult> putDetectorAsync(PutDetectorRequest request, final AsyncHandler<PutDetectorRequest, PutDetectorResult> asyncHandler) {
        final PutDetectorRequest finalRequest = (PutDetectorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDetectorResult>(){

            @Override
            public PutDetectorResult call() throws Exception {
                PutDetectorResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutDetector(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutEntityTypeResult> putEntityTypeAsync(PutEntityTypeRequest request) {
        return this.putEntityTypeAsync(request, null);
    }

    @Override
    public Future<PutEntityTypeResult> putEntityTypeAsync(PutEntityTypeRequest request, final AsyncHandler<PutEntityTypeRequest, PutEntityTypeResult> asyncHandler) {
        final PutEntityTypeRequest finalRequest = (PutEntityTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutEntityTypeResult>(){

            @Override
            public PutEntityTypeResult call() throws Exception {
                PutEntityTypeResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutEntityType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutEventTypeResult> putEventTypeAsync(PutEventTypeRequest request) {
        return this.putEventTypeAsync(request, null);
    }

    @Override
    public Future<PutEventTypeResult> putEventTypeAsync(PutEventTypeRequest request, final AsyncHandler<PutEventTypeRequest, PutEventTypeResult> asyncHandler) {
        final PutEventTypeRequest finalRequest = (PutEventTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutEventTypeResult>(){

            @Override
            public PutEventTypeResult call() throws Exception {
                PutEventTypeResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutEventType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutExternalModelResult> putExternalModelAsync(PutExternalModelRequest request) {
        return this.putExternalModelAsync(request, null);
    }

    @Override
    public Future<PutExternalModelResult> putExternalModelAsync(PutExternalModelRequest request, final AsyncHandler<PutExternalModelRequest, PutExternalModelResult> asyncHandler) {
        final PutExternalModelRequest finalRequest = (PutExternalModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutExternalModelResult>(){

            @Override
            public PutExternalModelResult call() throws Exception {
                PutExternalModelResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutExternalModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutKMSEncryptionKeyResult> putKMSEncryptionKeyAsync(PutKMSEncryptionKeyRequest request) {
        return this.putKMSEncryptionKeyAsync(request, null);
    }

    @Override
    public Future<PutKMSEncryptionKeyResult> putKMSEncryptionKeyAsync(PutKMSEncryptionKeyRequest request, final AsyncHandler<PutKMSEncryptionKeyRequest, PutKMSEncryptionKeyResult> asyncHandler) {
        final PutKMSEncryptionKeyRequest finalRequest = (PutKMSEncryptionKeyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutKMSEncryptionKeyResult>(){

            @Override
            public PutKMSEncryptionKeyResult call() throws Exception {
                PutKMSEncryptionKeyResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutKMSEncryptionKey(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLabelResult> putLabelAsync(PutLabelRequest request) {
        return this.putLabelAsync(request, null);
    }

    @Override
    public Future<PutLabelResult> putLabelAsync(PutLabelRequest request, final AsyncHandler<PutLabelRequest, PutLabelResult> asyncHandler) {
        final PutLabelRequest finalRequest = (PutLabelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutLabelResult>(){

            @Override
            public PutLabelResult call() throws Exception {
                PutLabelResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutLabel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutOutcomeResult> putOutcomeAsync(PutOutcomeRequest request) {
        return this.putOutcomeAsync(request, null);
    }

    @Override
    public Future<PutOutcomeResult> putOutcomeAsync(PutOutcomeRequest request, final AsyncHandler<PutOutcomeRequest, PutOutcomeResult> asyncHandler) {
        final PutOutcomeRequest finalRequest = (PutOutcomeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutOutcomeResult>(){

            @Override
            public PutOutcomeResult call() throws Exception {
                PutOutcomeResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executePutOutcome(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDetectorVersionResult> updateDetectorVersionAsync(UpdateDetectorVersionRequest request) {
        return this.updateDetectorVersionAsync(request, null);
    }

    @Override
    public Future<UpdateDetectorVersionResult> updateDetectorVersionAsync(UpdateDetectorVersionRequest request, final AsyncHandler<UpdateDetectorVersionRequest, UpdateDetectorVersionResult> asyncHandler) {
        final UpdateDetectorVersionRequest finalRequest = (UpdateDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDetectorVersionResult>(){

            @Override
            public UpdateDetectorVersionResult call() throws Exception {
                UpdateDetectorVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateDetectorVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDetectorVersionMetadataResult> updateDetectorVersionMetadataAsync(UpdateDetectorVersionMetadataRequest request) {
        return this.updateDetectorVersionMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateDetectorVersionMetadataResult> updateDetectorVersionMetadataAsync(UpdateDetectorVersionMetadataRequest request, final AsyncHandler<UpdateDetectorVersionMetadataRequest, UpdateDetectorVersionMetadataResult> asyncHandler) {
        final UpdateDetectorVersionMetadataRequest finalRequest = (UpdateDetectorVersionMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDetectorVersionMetadataResult>(){

            @Override
            public UpdateDetectorVersionMetadataResult call() throws Exception {
                UpdateDetectorVersionMetadataResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateDetectorVersionMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDetectorVersionStatusResult> updateDetectorVersionStatusAsync(UpdateDetectorVersionStatusRequest request) {
        return this.updateDetectorVersionStatusAsync(request, null);
    }

    @Override
    public Future<UpdateDetectorVersionStatusResult> updateDetectorVersionStatusAsync(UpdateDetectorVersionStatusRequest request, final AsyncHandler<UpdateDetectorVersionStatusRequest, UpdateDetectorVersionStatusResult> asyncHandler) {
        final UpdateDetectorVersionStatusRequest finalRequest = (UpdateDetectorVersionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDetectorVersionStatusResult>(){

            @Override
            public UpdateDetectorVersionStatusResult call() throws Exception {
                UpdateDetectorVersionStatusResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateDetectorVersionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateModelResult> updateModelAsync(UpdateModelRequest request) {
        return this.updateModelAsync(request, null);
    }

    @Override
    public Future<UpdateModelResult> updateModelAsync(UpdateModelRequest request, final AsyncHandler<UpdateModelRequest, UpdateModelResult> asyncHandler) {
        final UpdateModelRequest finalRequest = (UpdateModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateModelResult>(){

            @Override
            public UpdateModelResult call() throws Exception {
                UpdateModelResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateModelVersionResult> updateModelVersionAsync(UpdateModelVersionRequest request) {
        return this.updateModelVersionAsync(request, null);
    }

    @Override
    public Future<UpdateModelVersionResult> updateModelVersionAsync(UpdateModelVersionRequest request, final AsyncHandler<UpdateModelVersionRequest, UpdateModelVersionResult> asyncHandler) {
        final UpdateModelVersionRequest finalRequest = (UpdateModelVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateModelVersionResult>(){

            @Override
            public UpdateModelVersionResult call() throws Exception {
                UpdateModelVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateModelVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateModelVersionStatusResult> updateModelVersionStatusAsync(UpdateModelVersionStatusRequest request) {
        return this.updateModelVersionStatusAsync(request, null);
    }

    @Override
    public Future<UpdateModelVersionStatusResult> updateModelVersionStatusAsync(UpdateModelVersionStatusRequest request, final AsyncHandler<UpdateModelVersionStatusRequest, UpdateModelVersionStatusResult> asyncHandler) {
        final UpdateModelVersionStatusRequest finalRequest = (UpdateModelVersionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateModelVersionStatusResult>(){

            @Override
            public UpdateModelVersionStatusResult call() throws Exception {
                UpdateModelVersionStatusResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateModelVersionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRuleMetadataResult> updateRuleMetadataAsync(UpdateRuleMetadataRequest request) {
        return this.updateRuleMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateRuleMetadataResult> updateRuleMetadataAsync(UpdateRuleMetadataRequest request, final AsyncHandler<UpdateRuleMetadataRequest, UpdateRuleMetadataResult> asyncHandler) {
        final UpdateRuleMetadataRequest finalRequest = (UpdateRuleMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRuleMetadataResult>(){

            @Override
            public UpdateRuleMetadataResult call() throws Exception {
                UpdateRuleMetadataResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateRuleMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRuleVersionResult> updateRuleVersionAsync(UpdateRuleVersionRequest request) {
        return this.updateRuleVersionAsync(request, null);
    }

    @Override
    public Future<UpdateRuleVersionResult> updateRuleVersionAsync(UpdateRuleVersionRequest request, final AsyncHandler<UpdateRuleVersionRequest, UpdateRuleVersionResult> asyncHandler) {
        final UpdateRuleVersionRequest finalRequest = (UpdateRuleVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRuleVersionResult>(){

            @Override
            public UpdateRuleVersionResult call() throws Exception {
                UpdateRuleVersionResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateRuleVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVariableResult> updateVariableAsync(UpdateVariableRequest request) {
        return this.updateVariableAsync(request, null);
    }

    @Override
    public Future<UpdateVariableResult> updateVariableAsync(UpdateVariableRequest request, final AsyncHandler<UpdateVariableRequest, UpdateVariableResult> asyncHandler) {
        final UpdateVariableRequest finalRequest = (UpdateVariableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVariableResult>(){

            @Override
            public UpdateVariableResult call() throws Exception {
                UpdateVariableResult result = null;
                try {
                    result = AmazonFraudDetectorAsyncClient.this.executeUpdateVariable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

