/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.fsx.model.RestoreOpenZFSVolumeOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RestoreVolumeFromSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientRequestToken;
    private String volumeId;
    private String snapshotId;
    private List<String> options;

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public RestoreVolumeFromSnapshotRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public RestoreVolumeFromSnapshotRequest withVolumeId(String volumeId) {
        this.setVolumeId(volumeId);
        return this;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public RestoreVolumeFromSnapshotRequest withSnapshotId(String snapshotId) {
        this.setSnapshotId(snapshotId);
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(Collection<String> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        this.options = new ArrayList<String>(options);
    }

    public RestoreVolumeFromSnapshotRequest withOptions(String ... options) {
        if (this.options == null) {
            this.setOptions(new ArrayList<String>(options.length));
        }
        for (String ele : options) {
            this.options.add(ele);
        }
        return this;
    }

    public RestoreVolumeFromSnapshotRequest withOptions(Collection<String> options) {
        this.setOptions(options);
        return this;
    }

    public RestoreVolumeFromSnapshotRequest withOptions(RestoreOpenZFSVolumeOption ... options) {
        ArrayList<String> optionsCopy = new ArrayList<String>(options.length);
        for (RestoreOpenZFSVolumeOption value : options) {
            optionsCopy.add(value.toString());
        }
        if (this.getOptions() == null) {
            this.setOptions(optionsCopy);
        } else {
            this.getOptions().addAll(optionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getVolumeId() != null) {
            sb.append("VolumeId: ").append(this.getVolumeId()).append(",");
        }
        if (this.getSnapshotId() != null) {
            sb.append("SnapshotId: ").append(this.getSnapshotId()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreVolumeFromSnapshotRequest)) {
            return false;
        }
        RestoreVolumeFromSnapshotRequest other = (RestoreVolumeFromSnapshotRequest)obj;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getVolumeId() == null ^ this.getVolumeId() == null) {
            return false;
        }
        if (other.getVolumeId() != null && !other.getVolumeId().equals(this.getVolumeId())) {
            return false;
        }
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null) {
            return false;
        }
        if (other.getSnapshotId() != null && !other.getSnapshotId().equals(this.getSnapshotId())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeId() == null ? 0 : this.getVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotId() == null ? 0 : this.getSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public RestoreVolumeFromSnapshotRequest clone() {
        return (RestoreVolumeFromSnapshotRequest)super.clone();
    }
}

