/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.transform.AggregateConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AggregateConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> aggregates;
    private Integer totalConstituents;

    public List<String> getAggregates() {
        return this.aggregates;
    }

    public void setAggregates(Collection<String> aggregates) {
        if (aggregates == null) {
            this.aggregates = null;
            return;
        }
        this.aggregates = new ArrayList<String>(aggregates);
    }

    public AggregateConfiguration withAggregates(String ... aggregates) {
        if (this.aggregates == null) {
            this.setAggregates(new ArrayList<String>(aggregates.length));
        }
        for (String ele : aggregates) {
            this.aggregates.add(ele);
        }
        return this;
    }

    public AggregateConfiguration withAggregates(Collection<String> aggregates) {
        this.setAggregates(aggregates);
        return this;
    }

    public void setTotalConstituents(Integer totalConstituents) {
        this.totalConstituents = totalConstituents;
    }

    public Integer getTotalConstituents() {
        return this.totalConstituents;
    }

    public AggregateConfiguration withTotalConstituents(Integer totalConstituents) {
        this.setTotalConstituents(totalConstituents);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAggregates() != null) {
            sb.append("Aggregates: ").append(this.getAggregates()).append(",");
        }
        if (this.getTotalConstituents() != null) {
            sb.append("TotalConstituents: ").append(this.getTotalConstituents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConfiguration)) {
            return false;
        }
        AggregateConfiguration other = (AggregateConfiguration)obj;
        if (other.getAggregates() == null ^ this.getAggregates() == null) {
            return false;
        }
        if (other.getAggregates() != null && !other.getAggregates().equals(this.getAggregates())) {
            return false;
        }
        if (other.getTotalConstituents() == null ^ this.getTotalConstituents() == null) {
            return false;
        }
        return other.getTotalConstituents() == null || other.getTotalConstituents().equals(this.getTotalConstituents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAggregates() == null ? 0 : this.getAggregates().hashCode());
        hashCode = 31 * hashCode + (this.getTotalConstituents() == null ? 0 : this.getTotalConstituents().hashCode());
        return hashCode;
    }

    public AggregateConfiguration clone() {
        try {
            return (AggregateConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregateConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

