/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.glue.model.SchemaListItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSchemasResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SchemaListItem> schemas;
    private String nextToken;

    public List<SchemaListItem> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<SchemaListItem> schemas) {
        if (schemas == null) {
            this.schemas = null;
            return;
        }
        this.schemas = new ArrayList<SchemaListItem>(schemas);
    }

    public ListSchemasResult withSchemas(SchemaListItem ... schemas) {
        if (this.schemas == null) {
            this.setSchemas(new ArrayList<SchemaListItem>(schemas.length));
        }
        for (SchemaListItem ele : schemas) {
            this.schemas.add(ele);
        }
        return this;
    }

    public ListSchemasResult withSchemas(Collection<SchemaListItem> schemas) {
        this.setSchemas(schemas);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSchemasResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSchemas() != null) {
            sb.append("Schemas: ").append(this.getSchemas()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasResult)) {
            return false;
        }
        ListSchemasResult other = (ListSchemasResult)obj;
        if (other.getSchemas() == null ^ this.getSchemas() == null) {
            return false;
        }
        if (other.getSchemas() != null && !other.getSchemas().equals(this.getSchemas())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSchemas() == null ? 0 : this.getSchemas().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSchemasResult clone() {
        try {
            return (ListSchemasResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

