/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.PrincipalType;
import com.amazonaws.services.glue.model.ResourceUri;
import com.amazonaws.services.glue.model.transform.UserDefinedFunctionInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserDefinedFunctionInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String functionName;
    private String className;
    private String ownerName;
    private String ownerType;
    private List<ResourceUri> resourceUris;

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public UserDefinedFunctionInput withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public UserDefinedFunctionInput withClassName(String className) {
        this.setClassName(className);
        return this;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UserDefinedFunctionInput withOwnerName(String ownerName) {
        this.setOwnerName(ownerName);
        return this;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public UserDefinedFunctionInput withOwnerType(String ownerType) {
        this.setOwnerType(ownerType);
        return this;
    }

    public UserDefinedFunctionInput withOwnerType(PrincipalType ownerType) {
        this.ownerType = ownerType.toString();
        return this;
    }

    public List<ResourceUri> getResourceUris() {
        return this.resourceUris;
    }

    public void setResourceUris(Collection<ResourceUri> resourceUris) {
        if (resourceUris == null) {
            this.resourceUris = null;
            return;
        }
        this.resourceUris = new ArrayList<ResourceUri>(resourceUris);
    }

    public UserDefinedFunctionInput withResourceUris(ResourceUri ... resourceUris) {
        if (this.resourceUris == null) {
            this.setResourceUris(new ArrayList<ResourceUri>(resourceUris.length));
        }
        for (ResourceUri ele : resourceUris) {
            this.resourceUris.add(ele);
        }
        return this;
    }

    public UserDefinedFunctionInput withResourceUris(Collection<ResourceUri> resourceUris) {
        this.setResourceUris(resourceUris);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionName() != null) {
            sb.append("FunctionName: ").append(this.getFunctionName()).append(",");
        }
        if (this.getClassName() != null) {
            sb.append("ClassName: ").append(this.getClassName()).append(",");
        }
        if (this.getOwnerName() != null) {
            sb.append("OwnerName: ").append(this.getOwnerName()).append(",");
        }
        if (this.getOwnerType() != null) {
            sb.append("OwnerType: ").append(this.getOwnerType()).append(",");
        }
        if (this.getResourceUris() != null) {
            sb.append("ResourceUris: ").append(this.getResourceUris());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDefinedFunctionInput)) {
            return false;
        }
        UserDefinedFunctionInput other = (UserDefinedFunctionInput)obj;
        if (other.getFunctionName() == null ^ this.getFunctionName() == null) {
            return false;
        }
        if (other.getFunctionName() != null && !other.getFunctionName().equals(this.getFunctionName())) {
            return false;
        }
        if (other.getClassName() == null ^ this.getClassName() == null) {
            return false;
        }
        if (other.getClassName() != null && !other.getClassName().equals(this.getClassName())) {
            return false;
        }
        if (other.getOwnerName() == null ^ this.getOwnerName() == null) {
            return false;
        }
        if (other.getOwnerName() != null && !other.getOwnerName().equals(this.getOwnerName())) {
            return false;
        }
        if (other.getOwnerType() == null ^ this.getOwnerType() == null) {
            return false;
        }
        if (other.getOwnerType() != null && !other.getOwnerType().equals(this.getOwnerType())) {
            return false;
        }
        if (other.getResourceUris() == null ^ this.getResourceUris() == null) {
            return false;
        }
        return other.getResourceUris() == null || other.getResourceUris().equals(this.getResourceUris());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionName() == null ? 0 : this.getFunctionName().hashCode());
        hashCode = 31 * hashCode + (this.getClassName() == null ? 0 : this.getClassName().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerName() == null ? 0 : this.getOwnerName().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerType() == null ? 0 : this.getOwnerType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceUris() == null ? 0 : this.getResourceUris().hashCode());
        return hashCode;
    }

    public UserDefinedFunctionInput clone() {
        try {
            return (UserDefinedFunctionInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserDefinedFunctionInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

