/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.ConditionExpression;
import com.amazonaws.services.gluedatabrew.model.RecipeAction;
import com.amazonaws.services.gluedatabrew.model.transform.RecipeStepMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RecipeStep
implements Serializable,
Cloneable,
StructuredPojo {
    private RecipeAction action;
    private List<ConditionExpression> conditionExpressions;

    public void setAction(RecipeAction action) {
        this.action = action;
    }

    public RecipeAction getAction() {
        return this.action;
    }

    public RecipeStep withAction(RecipeAction action) {
        this.setAction(action);
        return this;
    }

    public List<ConditionExpression> getConditionExpressions() {
        return this.conditionExpressions;
    }

    public void setConditionExpressions(Collection<ConditionExpression> conditionExpressions) {
        if (conditionExpressions == null) {
            this.conditionExpressions = null;
            return;
        }
        this.conditionExpressions = new ArrayList<ConditionExpression>(conditionExpressions);
    }

    public RecipeStep withConditionExpressions(ConditionExpression ... conditionExpressions) {
        if (this.conditionExpressions == null) {
            this.setConditionExpressions(new ArrayList<ConditionExpression>(conditionExpressions.length));
        }
        for (ConditionExpression ele : conditionExpressions) {
            this.conditionExpressions.add(ele);
        }
        return this;
    }

    public RecipeStep withConditionExpressions(Collection<ConditionExpression> conditionExpressions) {
        this.setConditionExpressions(conditionExpressions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getConditionExpressions() != null) {
            sb.append("ConditionExpressions: ").append(this.getConditionExpressions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipeStep)) {
            return false;
        }
        RecipeStep other = (RecipeStep)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getConditionExpressions() == null ^ this.getConditionExpressions() == null) {
            return false;
        }
        return other.getConditionExpressions() == null || other.getConditionExpressions().equals(this.getConditionExpressions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getConditionExpressions() == null ? 0 : this.getConditionExpressions().hashCode());
        return hashCode;
    }

    public RecipeStep clone() {
        try {
            return (RecipeStep)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecipeStepMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

