/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.gluedatabrew.model.RecipeReference;

@SdkInternalApi
public class RecipeReferenceMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> RECIPEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecipeVersion").build();
    private static final RecipeReferenceMarshaller instance = new RecipeReferenceMarshaller();

    public static RecipeReferenceMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecipeReference recipeReference, ProtocolMarshaller protocolMarshaller) {
        if (recipeReference == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recipeReference.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)recipeReference.getRecipeVersion(), RECIPEVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

