/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMalwareProtectionPlan" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetMalwareProtectionPlanResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Amazon Resource Name (ARN) of the protected resource.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     * </p>
     */
    private String role;
    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     */
    private CreateProtectedResource protectedResource;
    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     */
    private MalwareProtectionPlanActions actions;
    /**
     * <p>
     * The timestamp when the Malware Protection plan resource was created.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * Malware Protection plan status.
     * </p>
     */
    private String status;
    /**
     * <p>
     * Information about the issue code and message associated to the status of your Malware Protection plan.
     * </p>
     */
    private java.util.List<MalwareProtectionPlanStatusReason> statusReasons;
    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     */
    private java.util.Map<String, String> tags;

    /**
     * <p>
     * Amazon Resource Name (ARN) of the protected resource.
     * </p>
     * 
     * @param arn
     *        Amazon Resource Name (ARN) of the protected resource.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the protected resource.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the protected resource.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the protected resource.
     * </p>
     * 
     * @param arn
     *        Amazon Resource Name (ARN) of the protected resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @param role
     *        IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     */

    public void setRole(String role) {
        this.role = role;
    }

    /**
     * <p>
     * IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @return IAM role that includes the permissions required to scan and add tags to the associated protected
     *         resource.
     */

    public String getRole() {
        return this.role;
    }

    /**
     * <p>
     * IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @param role
     *        IAM role that includes the permissions required to scan and add tags to the associated protected resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult withRole(String role) {
        setRole(role);
        return this;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @param protectedResource
     *        Information about the protected resource that is associated with the created Malware Protection plan.
     *        Presently, <code>S3Bucket</code> is the only supported protected resource.
     */

    public void setProtectedResource(CreateProtectedResource protectedResource) {
        this.protectedResource = protectedResource;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @return Information about the protected resource that is associated with the created Malware Protection plan.
     *         Presently, <code>S3Bucket</code> is the only supported protected resource.
     */

    public CreateProtectedResource getProtectedResource() {
        return this.protectedResource;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @param protectedResource
     *        Information about the protected resource that is associated with the created Malware Protection plan.
     *        Presently, <code>S3Bucket</code> is the only supported protected resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult withProtectedResource(CreateProtectedResource protectedResource) {
        setProtectedResource(protectedResource);
        return this;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @param actions
     *        Information about whether the tags will be added to the S3 object after scanning.
     */

    public void setActions(MalwareProtectionPlanActions actions) {
        this.actions = actions;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @return Information about whether the tags will be added to the S3 object after scanning.
     */

    public MalwareProtectionPlanActions getActions() {
        return this.actions;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @param actions
     *        Information about whether the tags will be added to the S3 object after scanning.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult withActions(MalwareProtectionPlanActions actions) {
        setActions(actions);
        return this;
    }

    /**
     * <p>
     * The timestamp when the Malware Protection plan resource was created.
     * </p>
     * 
     * @param createdAt
     *        The timestamp when the Malware Protection plan resource was created.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The timestamp when the Malware Protection plan resource was created.
     * </p>
     * 
     * @return The timestamp when the Malware Protection plan resource was created.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The timestamp when the Malware Protection plan resource was created.
     * </p>
     * 
     * @param createdAt
     *        The timestamp when the Malware Protection plan resource was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * Malware Protection plan status.
     * </p>
     * 
     * @param status
     *        Malware Protection plan status.
     * @see MalwareProtectionPlanStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Malware Protection plan status.
     * </p>
     * 
     * @return Malware Protection plan status.
     * @see MalwareProtectionPlanStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Malware Protection plan status.
     * </p>
     * 
     * @param status
     *        Malware Protection plan status.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MalwareProtectionPlanStatus
     */

    public GetMalwareProtectionPlanResult withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Malware Protection plan status.
     * </p>
     * 
     * @param status
     *        Malware Protection plan status.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MalwareProtectionPlanStatus
     */

    public GetMalwareProtectionPlanResult withStatus(MalwareProtectionPlanStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * Information about the issue code and message associated to the status of your Malware Protection plan.
     * </p>
     * 
     * @return Information about the issue code and message associated to the status of your Malware Protection plan.
     */

    public java.util.List<MalwareProtectionPlanStatusReason> getStatusReasons() {
        return statusReasons;
    }

    /**
     * <p>
     * Information about the issue code and message associated to the status of your Malware Protection plan.
     * </p>
     * 
     * @param statusReasons
     *        Information about the issue code and message associated to the status of your Malware Protection plan.
     */

    public void setStatusReasons(java.util.Collection<MalwareProtectionPlanStatusReason> statusReasons) {
        if (statusReasons == null) {
            this.statusReasons = null;
            return;
        }

        this.statusReasons = new java.util.ArrayList<MalwareProtectionPlanStatusReason>(statusReasons);
    }

    /**
     * <p>
     * Information about the issue code and message associated to the status of your Malware Protection plan.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setStatusReasons(java.util.Collection)} or {@link #withStatusReasons(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param statusReasons
     *        Information about the issue code and message associated to the status of your Malware Protection plan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult withStatusReasons(MalwareProtectionPlanStatusReason... statusReasons) {
        if (this.statusReasons == null) {
            setStatusReasons(new java.util.ArrayList<MalwareProtectionPlanStatusReason>(statusReasons.length));
        }
        for (MalwareProtectionPlanStatusReason ele : statusReasons) {
            this.statusReasons.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the issue code and message associated to the status of your Malware Protection plan.
     * </p>
     * 
     * @param statusReasons
     *        Information about the issue code and message associated to the status of your Malware Protection plan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult withStatusReasons(java.util.Collection<MalwareProtectionPlanStatusReason> statusReasons) {
        setStatusReasons(statusReasons);
        return this;
    }

    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     * 
     * @return Tags added to the Malware Protection plan resource.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     * 
     * @param tags
     *        Tags added to the Malware Protection plan resource.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * Tags added to the Malware Protection plan resource.
     * </p>
     * 
     * @param tags
     *        Tags added to the Malware Protection plan resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see GetMalwareProtectionPlanResult#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetMalwareProtectionPlanResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getRole() != null)
            sb.append("Role: ").append(getRole()).append(",");
        if (getProtectedResource() != null)
            sb.append("ProtectedResource: ").append(getProtectedResource()).append(",");
        if (getActions() != null)
            sb.append("Actions: ").append(getActions()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getStatusReasons() != null)
            sb.append("StatusReasons: ").append(getStatusReasons()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetMalwareProtectionPlanResult == false)
            return false;
        GetMalwareProtectionPlanResult other = (GetMalwareProtectionPlanResult) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getRole() == null ^ this.getRole() == null)
            return false;
        if (other.getRole() != null && other.getRole().equals(this.getRole()) == false)
            return false;
        if (other.getProtectedResource() == null ^ this.getProtectedResource() == null)
            return false;
        if (other.getProtectedResource() != null && other.getProtectedResource().equals(this.getProtectedResource()) == false)
            return false;
        if (other.getActions() == null ^ this.getActions() == null)
            return false;
        if (other.getActions() != null && other.getActions().equals(this.getActions()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getStatusReasons() == null ^ this.getStatusReasons() == null)
            return false;
        if (other.getStatusReasons() != null && other.getStatusReasons().equals(this.getStatusReasons()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getRole() == null) ? 0 : getRole().hashCode());
        hashCode = prime * hashCode + ((getProtectedResource() == null) ? 0 : getProtectedResource().hashCode());
        hashCode = prime * hashCode + ((getActions() == null) ? 0 : getActions().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getStatusReasons() == null) ? 0 : getStatusReasons().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public GetMalwareProtectionPlanResult clone() {
        try {
            return (GetMalwareProtectionPlanResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
