/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An object that contains information on the status of all Malware Protection data sources.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionConfigurationResult"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MalwareProtectionConfigurationResult implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Describes the configuration of Malware Protection for EC2 instances with findings.
     * </p>
     */
    private ScanEc2InstanceWithFindingsResult scanEc2InstanceWithFindings;
    /**
     * <p>
     * The GuardDuty Malware Protection service role.
     * </p>
     */
    private String serviceRole;

    /**
     * <p>
     * Describes the configuration of Malware Protection for EC2 instances with findings.
     * </p>
     * 
     * @param scanEc2InstanceWithFindings
     *        Describes the configuration of Malware Protection for EC2 instances with findings.
     */

    public void setScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult scanEc2InstanceWithFindings) {
        this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings;
    }

    /**
     * <p>
     * Describes the configuration of Malware Protection for EC2 instances with findings.
     * </p>
     * 
     * @return Describes the configuration of Malware Protection for EC2 instances with findings.
     */

    public ScanEc2InstanceWithFindingsResult getScanEc2InstanceWithFindings() {
        return this.scanEc2InstanceWithFindings;
    }

    /**
     * <p>
     * Describes the configuration of Malware Protection for EC2 instances with findings.
     * </p>
     * 
     * @param scanEc2InstanceWithFindings
     *        Describes the configuration of Malware Protection for EC2 instances with findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MalwareProtectionConfigurationResult withScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsResult scanEc2InstanceWithFindings) {
        setScanEc2InstanceWithFindings(scanEc2InstanceWithFindings);
        return this;
    }

    /**
     * <p>
     * The GuardDuty Malware Protection service role.
     * </p>
     * 
     * @param serviceRole
     *        The GuardDuty Malware Protection service role.
     */

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    /**
     * <p>
     * The GuardDuty Malware Protection service role.
     * </p>
     * 
     * @return The GuardDuty Malware Protection service role.
     */

    public String getServiceRole() {
        return this.serviceRole;
    }

    /**
     * <p>
     * The GuardDuty Malware Protection service role.
     * </p>
     * 
     * @param serviceRole
     *        The GuardDuty Malware Protection service role.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MalwareProtectionConfigurationResult withServiceRole(String serviceRole) {
        setServiceRole(serviceRole);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getScanEc2InstanceWithFindings() != null)
            sb.append("ScanEc2InstanceWithFindings: ").append(getScanEc2InstanceWithFindings()).append(",");
        if (getServiceRole() != null)
            sb.append("ServiceRole: ").append(getServiceRole());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MalwareProtectionConfigurationResult == false)
            return false;
        MalwareProtectionConfigurationResult other = (MalwareProtectionConfigurationResult) obj;
        if (other.getScanEc2InstanceWithFindings() == null ^ this.getScanEc2InstanceWithFindings() == null)
            return false;
        if (other.getScanEc2InstanceWithFindings() != null && other.getScanEc2InstanceWithFindings().equals(this.getScanEc2InstanceWithFindings()) == false)
            return false;
        if (other.getServiceRole() == null ^ this.getServiceRole() == null)
            return false;
        if (other.getServiceRole() != null && other.getServiceRole().equals(this.getServiceRole()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getScanEc2InstanceWithFindings() == null) ? 0 : getScanEc2InstanceWithFindings().hashCode());
        hashCode = prime * hashCode + ((getServiceRole() == null) ? 0 : getServiceRole().hashCode());
        return hashCode;
    }

    @Override
    public MalwareProtectionConfigurationResult clone() {
        try {
            return (MalwareProtectionConfigurationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.guardduty.model.transform.MalwareProtectionConfigurationResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
