/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about the malware scan that generated a GuardDuty finding.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareScanDetails" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MalwareScanDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Information about the detected threats associated with the generated GuardDuty finding.
     * </p>
     */
    private java.util.List<Threat> threats;

    /**
     * <p>
     * Information about the detected threats associated with the generated GuardDuty finding.
     * </p>
     * 
     * @return Information about the detected threats associated with the generated GuardDuty finding.
     */

    public java.util.List<Threat> getThreats() {
        return threats;
    }

    /**
     * <p>
     * Information about the detected threats associated with the generated GuardDuty finding.
     * </p>
     * 
     * @param threats
     *        Information about the detected threats associated with the generated GuardDuty finding.
     */

    public void setThreats(java.util.Collection<Threat> threats) {
        if (threats == null) {
            this.threats = null;
            return;
        }

        this.threats = new java.util.ArrayList<Threat>(threats);
    }

    /**
     * <p>
     * Information about the detected threats associated with the generated GuardDuty finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreats(java.util.Collection)} or {@link #withThreats(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param threats
     *        Information about the detected threats associated with the generated GuardDuty finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MalwareScanDetails withThreats(Threat... threats) {
        if (this.threats == null) {
            setThreats(new java.util.ArrayList<Threat>(threats.length));
        }
        for (Threat ele : threats) {
            this.threats.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the detected threats associated with the generated GuardDuty finding.
     * </p>
     * 
     * @param threats
     *        Information about the detected threats associated with the generated GuardDuty finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MalwareScanDetails withThreats(java.util.Collection<Threat> threats) {
        setThreats(threats);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getThreats() != null)
            sb.append("Threats: ").append(getThreats());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MalwareScanDetails == false)
            return false;
        MalwareScanDetails other = (MalwareScanDetails) obj;
        if (other.getThreats() == null ^ this.getThreats() == null)
            return false;
        if (other.getThreats() != null && other.getThreats().equals(this.getThreats()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getThreats() == null) ? 0 : getThreats().hashCode());
        return hashCode;
    }

    @Override
    public MalwareScanDetails clone() {
        try {
            return (MalwareScanDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.guardduty.model.transform.MalwareScanDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
