/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateMalwareProtectionPlan"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateMalwareProtectionPlanRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique identifier associated with the Malware Protection plan.
     * </p>
     */
    private String malwareProtectionPlanId;
    /**
     * <p>
     * IAM role with permissions required to scan and add tags to the associated protected resource.
     * </p>
     */
    private String role;
    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     */
    private MalwareProtectionPlanActions actions;
    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     */
    private UpdateProtectedResource protectedResource;

    /**
     * <p>
     * A unique identifier associated with the Malware Protection plan.
     * </p>
     * 
     * @param malwareProtectionPlanId
     *        A unique identifier associated with the Malware Protection plan.
     */

    public void setMalwareProtectionPlanId(String malwareProtectionPlanId) {
        this.malwareProtectionPlanId = malwareProtectionPlanId;
    }

    /**
     * <p>
     * A unique identifier associated with the Malware Protection plan.
     * </p>
     * 
     * @return A unique identifier associated with the Malware Protection plan.
     */

    public String getMalwareProtectionPlanId() {
        return this.malwareProtectionPlanId;
    }

    /**
     * <p>
     * A unique identifier associated with the Malware Protection plan.
     * </p>
     * 
     * @param malwareProtectionPlanId
     *        A unique identifier associated with the Malware Protection plan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMalwareProtectionPlanRequest withMalwareProtectionPlanId(String malwareProtectionPlanId) {
        setMalwareProtectionPlanId(malwareProtectionPlanId);
        return this;
    }

    /**
     * <p>
     * IAM role with permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @param role
     *        IAM role with permissions required to scan and add tags to the associated protected resource.
     */

    public void setRole(String role) {
        this.role = role;
    }

    /**
     * <p>
     * IAM role with permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @return IAM role with permissions required to scan and add tags to the associated protected resource.
     */

    public String getRole() {
        return this.role;
    }

    /**
     * <p>
     * IAM role with permissions required to scan and add tags to the associated protected resource.
     * </p>
     * 
     * @param role
     *        IAM role with permissions required to scan and add tags to the associated protected resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMalwareProtectionPlanRequest withRole(String role) {
        setRole(role);
        return this;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @param actions
     *        Information about whether the tags will be added to the S3 object after scanning.
     */

    public void setActions(MalwareProtectionPlanActions actions) {
        this.actions = actions;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @return Information about whether the tags will be added to the S3 object after scanning.
     */

    public MalwareProtectionPlanActions getActions() {
        return this.actions;
    }

    /**
     * <p>
     * Information about whether the tags will be added to the S3 object after scanning.
     * </p>
     * 
     * @param actions
     *        Information about whether the tags will be added to the S3 object after scanning.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMalwareProtectionPlanRequest withActions(MalwareProtectionPlanActions actions) {
        setActions(actions);
        return this;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @param protectedResource
     *        Information about the protected resource that is associated with the created Malware Protection plan.
     *        Presently, <code>S3Bucket</code> is the only supported protected resource.
     */

    public void setProtectedResource(UpdateProtectedResource protectedResource) {
        this.protectedResource = protectedResource;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @return Information about the protected resource that is associated with the created Malware Protection plan.
     *         Presently, <code>S3Bucket</code> is the only supported protected resource.
     */

    public UpdateProtectedResource getProtectedResource() {
        return this.protectedResource;
    }

    /**
     * <p>
     * Information about the protected resource that is associated with the created Malware Protection plan. Presently,
     * <code>S3Bucket</code> is the only supported protected resource.
     * </p>
     * 
     * @param protectedResource
     *        Information about the protected resource that is associated with the created Malware Protection plan.
     *        Presently, <code>S3Bucket</code> is the only supported protected resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMalwareProtectionPlanRequest withProtectedResource(UpdateProtectedResource protectedResource) {
        setProtectedResource(protectedResource);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMalwareProtectionPlanId() != null)
            sb.append("MalwareProtectionPlanId: ").append(getMalwareProtectionPlanId()).append(",");
        if (getRole() != null)
            sb.append("Role: ").append(getRole()).append(",");
        if (getActions() != null)
            sb.append("Actions: ").append(getActions()).append(",");
        if (getProtectedResource() != null)
            sb.append("ProtectedResource: ").append(getProtectedResource());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateMalwareProtectionPlanRequest == false)
            return false;
        UpdateMalwareProtectionPlanRequest other = (UpdateMalwareProtectionPlanRequest) obj;
        if (other.getMalwareProtectionPlanId() == null ^ this.getMalwareProtectionPlanId() == null)
            return false;
        if (other.getMalwareProtectionPlanId() != null && other.getMalwareProtectionPlanId().equals(this.getMalwareProtectionPlanId()) == false)
            return false;
        if (other.getRole() == null ^ this.getRole() == null)
            return false;
        if (other.getRole() != null && other.getRole().equals(this.getRole()) == false)
            return false;
        if (other.getActions() == null ^ this.getActions() == null)
            return false;
        if (other.getActions() != null && other.getActions().equals(this.getActions()) == false)
            return false;
        if (other.getProtectedResource() == null ^ this.getProtectedResource() == null)
            return false;
        if (other.getProtectedResource() != null && other.getProtectedResource().equals(this.getProtectedResource()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMalwareProtectionPlanId() == null) ? 0 : getMalwareProtectionPlanId().hashCode());
        hashCode = prime * hashCode + ((getRole() == null) ? 0 : getRole().hashCode());
        hashCode = prime * hashCode + ((getActions() == null) ? 0 : getActions().hashCode());
        hashCode = prime * hashCode + ((getProtectedResource() == null) ? 0 : getProtectedResource().hashCode());
        return hashCode;
    }

    @Override
    public UpdateMalwareProtectionPlanRequest clone() {
        return (UpdateMalwareProtectionPlanRequest) super.clone();
    }

}
