/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.health.model.DateTimeRange;
import com.amazonaws.services.health.model.EntityStatusCode;
import com.amazonaws.services.health.model.transform.EntityFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class EntityFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> eventArns;
    private List<String> entityArns;
    private List<String> entityValues;
    private List<DateTimeRange> lastUpdatedTimes;
    private List<Map<String, String>> tags;
    private List<String> statusCodes;

    public List<String> getEventArns() {
        return this.eventArns;
    }

    public void setEventArns(Collection<String> eventArns) {
        if (eventArns == null) {
            this.eventArns = null;
            return;
        }
        this.eventArns = new ArrayList<String>(eventArns);
    }

    public EntityFilter withEventArns(String ... eventArns) {
        if (this.eventArns == null) {
            this.setEventArns(new ArrayList<String>(eventArns.length));
        }
        for (String ele : eventArns) {
            this.eventArns.add(ele);
        }
        return this;
    }

    public EntityFilter withEventArns(Collection<String> eventArns) {
        this.setEventArns(eventArns);
        return this;
    }

    public List<String> getEntityArns() {
        return this.entityArns;
    }

    public void setEntityArns(Collection<String> entityArns) {
        if (entityArns == null) {
            this.entityArns = null;
            return;
        }
        this.entityArns = new ArrayList<String>(entityArns);
    }

    public EntityFilter withEntityArns(String ... entityArns) {
        if (this.entityArns == null) {
            this.setEntityArns(new ArrayList<String>(entityArns.length));
        }
        for (String ele : entityArns) {
            this.entityArns.add(ele);
        }
        return this;
    }

    public EntityFilter withEntityArns(Collection<String> entityArns) {
        this.setEntityArns(entityArns);
        return this;
    }

    public List<String> getEntityValues() {
        return this.entityValues;
    }

    public void setEntityValues(Collection<String> entityValues) {
        if (entityValues == null) {
            this.entityValues = null;
            return;
        }
        this.entityValues = new ArrayList<String>(entityValues);
    }

    public EntityFilter withEntityValues(String ... entityValues) {
        if (this.entityValues == null) {
            this.setEntityValues(new ArrayList<String>(entityValues.length));
        }
        for (String ele : entityValues) {
            this.entityValues.add(ele);
        }
        return this;
    }

    public EntityFilter withEntityValues(Collection<String> entityValues) {
        this.setEntityValues(entityValues);
        return this;
    }

    public List<DateTimeRange> getLastUpdatedTimes() {
        return this.lastUpdatedTimes;
    }

    public void setLastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
        if (lastUpdatedTimes == null) {
            this.lastUpdatedTimes = null;
            return;
        }
        this.lastUpdatedTimes = new ArrayList<DateTimeRange>(lastUpdatedTimes);
    }

    public EntityFilter withLastUpdatedTimes(DateTimeRange ... lastUpdatedTimes) {
        if (this.lastUpdatedTimes == null) {
            this.setLastUpdatedTimes(new ArrayList<DateTimeRange>(lastUpdatedTimes.length));
        }
        for (DateTimeRange ele : lastUpdatedTimes) {
            this.lastUpdatedTimes.add(ele);
        }
        return this;
    }

    public EntityFilter withLastUpdatedTimes(Collection<DateTimeRange> lastUpdatedTimes) {
        this.setLastUpdatedTimes(lastUpdatedTimes);
        return this;
    }

    public List<Map<String, String>> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Map<String, String>> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Map<String, String>>(tags);
    }

    public EntityFilter withTags(Map<String, String> ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Map<String, String>>(tags.length));
        }
        for (Map<String, String> ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public EntityFilter withTags(Collection<Map<String, String>> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getStatusCodes() {
        return this.statusCodes;
    }

    public void setStatusCodes(Collection<String> statusCodes) {
        if (statusCodes == null) {
            this.statusCodes = null;
            return;
        }
        this.statusCodes = new ArrayList<String>(statusCodes);
    }

    public EntityFilter withStatusCodes(String ... statusCodes) {
        if (this.statusCodes == null) {
            this.setStatusCodes(new ArrayList<String>(statusCodes.length));
        }
        for (String ele : statusCodes) {
            this.statusCodes.add(ele);
        }
        return this;
    }

    public EntityFilter withStatusCodes(Collection<String> statusCodes) {
        this.setStatusCodes(statusCodes);
        return this;
    }

    public EntityFilter withStatusCodes(EntityStatusCode ... statusCodes) {
        ArrayList<String> statusCodesCopy = new ArrayList<String>(statusCodes.length);
        for (EntityStatusCode value : statusCodes) {
            statusCodesCopy.add(value.toString());
        }
        if (this.getStatusCodes() == null) {
            this.setStatusCodes(statusCodesCopy);
        } else {
            this.getStatusCodes().addAll(statusCodesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventArns() != null) {
            sb.append("EventArns: ").append(this.getEventArns()).append(",");
        }
        if (this.getEntityArns() != null) {
            sb.append("EntityArns: ").append(this.getEntityArns()).append(",");
        }
        if (this.getEntityValues() != null) {
            sb.append("EntityValues: ").append(this.getEntityValues()).append(",");
        }
        if (this.getLastUpdatedTimes() != null) {
            sb.append("LastUpdatedTimes: ").append(this.getLastUpdatedTimes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getStatusCodes() != null) {
            sb.append("StatusCodes: ").append(this.getStatusCodes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityFilter)) {
            return false;
        }
        EntityFilter other = (EntityFilter)obj;
        if (other.getEventArns() == null ^ this.getEventArns() == null) {
            return false;
        }
        if (other.getEventArns() != null && !other.getEventArns().equals(this.getEventArns())) {
            return false;
        }
        if (other.getEntityArns() == null ^ this.getEntityArns() == null) {
            return false;
        }
        if (other.getEntityArns() != null && !other.getEntityArns().equals(this.getEntityArns())) {
            return false;
        }
        if (other.getEntityValues() == null ^ this.getEntityValues() == null) {
            return false;
        }
        if (other.getEntityValues() != null && !other.getEntityValues().equals(this.getEntityValues())) {
            return false;
        }
        if (other.getLastUpdatedTimes() == null ^ this.getLastUpdatedTimes() == null) {
            return false;
        }
        if (other.getLastUpdatedTimes() != null && !other.getLastUpdatedTimes().equals(this.getLastUpdatedTimes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getStatusCodes() == null ^ this.getStatusCodes() == null) {
            return false;
        }
        return other.getStatusCodes() == null || other.getStatusCodes().equals(this.getStatusCodes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventArns() == null ? 0 : this.getEventArns().hashCode());
        hashCode = 31 * hashCode + (this.getEntityArns() == null ? 0 : this.getEntityArns().hashCode());
        hashCode = 31 * hashCode + (this.getEntityValues() == null ? 0 : this.getEntityValues().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTimes() == null ? 0 : this.getLastUpdatedTimes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getStatusCodes() == null ? 0 : this.getStatusCodes().hashCode());
        return hashCode;
    }

    public EntityFilter clone() {
        try {
            return (EntityFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

