/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.DateTimeRange;
import com.amazonaws.services.health.model.EntityFilter;
import com.amazonaws.services.health.model.transform.DateTimeRangeJsonMarshaller;
import java.util.List;
import java.util.Map;

public class EntityFilterJsonMarshaller {
    private static EntityFilterJsonMarshaller instance;

    public void marshall(EntityFilter entityFilter, StructuredJsonGenerator jsonGenerator) {
        if (entityFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> list;
            List<Map<String, String>> list2;
            List<DateTimeRange> list3;
            List<String> list4;
            List<String> entityArnsList;
            jsonGenerator.writeStartObject();
            List<String> eventArnsList = entityFilter.getEventArns();
            if (eventArnsList != null) {
                jsonGenerator.writeFieldName("eventArns");
                jsonGenerator.writeStartArray();
                for (String string : eventArnsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((entityArnsList = entityFilter.getEntityArns()) != null) {
                jsonGenerator.writeFieldName("entityArns");
                jsonGenerator.writeStartArray();
                for (String string : entityArnsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list4 = entityFilter.getEntityValues()) != null) {
                jsonGenerator.writeFieldName("entityValues");
                jsonGenerator.writeStartArray();
                for (String string : list4) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list3 = entityFilter.getLastUpdatedTimes()) != null) {
                jsonGenerator.writeFieldName("lastUpdatedTimes");
                jsonGenerator.writeStartArray();
                for (DateTimeRange dateTimeRange : list3) {
                    if (dateTimeRange == null) continue;
                    DateTimeRangeJsonMarshaller.getInstance().marshall(dateTimeRange, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list2 = entityFilter.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartArray();
                for (Map<String, String> map : list2) {
                    if (map == null) continue;
                    jsonGenerator.writeStartObject();
                    for (Map.Entry<String, String> TagsListMapEntry : map.entrySet()) {
                        if (TagsListMapEntry.getValue() == null) continue;
                        jsonGenerator.writeFieldName(TagsListMapEntry.getKey());
                        jsonGenerator.writeValue(TagsListMapEntry.getValue());
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = entityFilter.getStatusCodes()) != null) {
                jsonGenerator.writeFieldName("statusCodes");
                jsonGenerator.writeStartArray();
                for (String statusCodesListValue : list) {
                    if (statusCodesListValue == null) continue;
                    jsonGenerator.writeValue(statusCodesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EntityFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EntityFilterJsonMarshaller();
        }
        return instance;
    }
}

