/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iamrolesanywhere;

import javax.annotation.Generated;

import com.amazonaws.services.iamrolesanywhere.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSIAMRolesAnywhere}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIAMRolesAnywhere implements AWSIAMRolesAnywhere {

    protected AbstractAWSIAMRolesAnywhere() {
    }

    @Override
    public CreateProfileResult createProfile(CreateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrustAnchorResult createTrustAnchor(CreateTrustAnchorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAttributeMappingResult deleteAttributeMapping(DeleteAttributeMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCrlResult deleteCrl(DeleteCrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProfileResult deleteProfile(DeleteProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrustAnchorResult deleteTrustAnchor(DeleteTrustAnchorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableCrlResult disableCrl(DisableCrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableProfileResult disableProfile(DisableProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableTrustAnchorResult disableTrustAnchor(DisableTrustAnchorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableCrlResult enableCrl(EnableCrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableProfileResult enableProfile(EnableProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableTrustAnchorResult enableTrustAnchor(EnableTrustAnchorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCrlResult getCrl(GetCrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubjectResult getSubject(GetSubjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTrustAnchorResult getTrustAnchor(GetTrustAnchorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportCrlResult importCrl(ImportCrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCrlsResult listCrls(ListCrlsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProfilesResult listProfiles(ListProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubjectsResult listSubjects(ListSubjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrustAnchorsResult listTrustAnchors(ListTrustAnchorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutAttributeMappingResult putAttributeMapping(PutAttributeMappingRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutNotificationSettingsResult putNotificationSettings(PutNotificationSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetNotificationSettingsResult resetNotificationSettings(ResetNotificationSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCrlResult updateCrl(UpdateCrlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProfileResult updateProfile(UpdateProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrustAnchorResult updateTrustAnchor(UpdateTrustAnchorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
