/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.imagebuilder.model.S3Logs;

@SdkInternalApi
public class S3LogsMarshaller {
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3BucketName").build();
    private static final MarshallingInfo<String> S3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3KeyPrefix").build();
    private static final S3LogsMarshaller instance = new S3LogsMarshaller();

    public static S3LogsMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Logs s3Logs, ProtocolMarshaller protocolMarshaller) {
        if (s3Logs == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Logs.getS3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3Logs.getS3KeyPrefix(), S3KEYPREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

