/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListApplicationsRequest;
import com.amazonaws.services.inspector.model.transform.ApplicationsFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListApplicationsRequestMarshaller
implements Marshaller<Request<ListApplicationsRequest>, ListApplicationsRequest> {
    public Request<ListApplicationsRequest> marshall(ListApplicationsRequest listApplicationsRequest) {
        if (listApplicationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listApplicationsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListApplications");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (listApplicationsRequest.getFilter() != null) {
                jsonWriter.key("filter");
                ApplicationsFilterJsonMarshaller.getInstance().marshall(listApplicationsRequest.getFilter(), jsonWriter);
            }
            if (listApplicationsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value((Object)listApplicationsRequest.getNextToken());
            }
            if (listApplicationsRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value((Object)listApplicationsRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

