/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.RunsFilter;
import com.amazonaws.services.inspector.model.transform.TimestampRangeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class RunsFilterJsonMarshaller {
    private static RunsFilterJsonMarshaller instance;

    public void marshall(RunsFilter runsFilter, JSONWriter jsonWriter) {
        if (runsFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> rulesPackagesList;
            List<String> runStatesList;
            jsonWriter.object();
            List<String> runNamePatternsList = runsFilter.getRunNamePatterns();
            if (runNamePatternsList != null) {
                jsonWriter.key("runNamePatterns");
                jsonWriter.array();
                for (String runNamePatternsListValue : runNamePatternsList) {
                    if (runNamePatternsListValue == null) continue;
                    jsonWriter.value((Object)runNamePatternsListValue);
                }
                jsonWriter.endArray();
            }
            if ((runStatesList = runsFilter.getRunStates()) != null) {
                jsonWriter.key("runStates");
                jsonWriter.array();
                for (String runStatesListValue : runStatesList) {
                    if (runStatesListValue == null) continue;
                    jsonWriter.value((Object)runStatesListValue);
                }
                jsonWriter.endArray();
            }
            if ((rulesPackagesList = runsFilter.getRulesPackages()) != null) {
                jsonWriter.key("rulesPackages");
                jsonWriter.array();
                for (String rulesPackagesListValue : rulesPackagesList) {
                    if (rulesPackagesListValue == null) continue;
                    jsonWriter.value((Object)rulesPackagesListValue);
                }
                jsonWriter.endArray();
            }
            if (runsFilter.getCreationTime() != null) {
                jsonWriter.key("creationTime");
                TimestampRangeJsonMarshaller.getInstance().marshall(runsFilter.getCreationTime(), jsonWriter);
            }
            if (runsFilter.getCompletionTime() != null) {
                jsonWriter.key("completionTime");
                TimestampRangeJsonMarshaller.getInstance().marshall(runsFilter.getCompletionTime(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RunsFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RunsFilterJsonMarshaller();
        }
        return instance;
    }
}

