/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.inspector.model.AssessmentTarget;
import com.amazonaws.services.inspector.model.FailedItemDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeAssessmentTargetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AssessmentTarget> assessmentTargets;
    private Map<String, FailedItemDetails> failedItems;

    public List<AssessmentTarget> getAssessmentTargets() {
        return this.assessmentTargets;
    }

    public void setAssessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
        if (assessmentTargets == null) {
            this.assessmentTargets = null;
            return;
        }
        this.assessmentTargets = new ArrayList<AssessmentTarget>(assessmentTargets);
    }

    public DescribeAssessmentTargetsResult withAssessmentTargets(AssessmentTarget ... assessmentTargets) {
        if (this.assessmentTargets == null) {
            this.setAssessmentTargets(new ArrayList<AssessmentTarget>(assessmentTargets.length));
        }
        for (AssessmentTarget ele : assessmentTargets) {
            this.assessmentTargets.add(ele);
        }
        return this;
    }

    public DescribeAssessmentTargetsResult withAssessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
        this.setAssessmentTargets(assessmentTargets);
        return this;
    }

    public Map<String, FailedItemDetails> getFailedItems() {
        return this.failedItems;
    }

    public void setFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.failedItems = failedItems;
    }

    public DescribeAssessmentTargetsResult withFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.setFailedItems(failedItems);
        return this;
    }

    public DescribeAssessmentTargetsResult addFailedItemsEntry(String key, FailedItemDetails value) {
        if (null == this.failedItems) {
            this.failedItems = new HashMap<String, FailedItemDetails>();
        }
        if (this.failedItems.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.failedItems.put(key, value);
        return this;
    }

    public DescribeAssessmentTargetsResult clearFailedItemsEntries() {
        this.failedItems = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssessmentTargets() != null) {
            sb.append("AssessmentTargets: ").append(this.getAssessmentTargets()).append(",");
        }
        if (this.getFailedItems() != null) {
            sb.append("FailedItems: ").append(this.getFailedItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentTargetsResult)) {
            return false;
        }
        DescribeAssessmentTargetsResult other = (DescribeAssessmentTargetsResult)obj;
        if (other.getAssessmentTargets() == null ^ this.getAssessmentTargets() == null) {
            return false;
        }
        if (other.getAssessmentTargets() != null && !other.getAssessmentTargets().equals(this.getAssessmentTargets())) {
            return false;
        }
        if (other.getFailedItems() == null ^ this.getFailedItems() == null) {
            return false;
        }
        return other.getFailedItems() == null || other.getFailedItems().equals(this.getFailedItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssessmentTargets() == null ? 0 : this.getAssessmentTargets().hashCode());
        hashCode = 31 * hashCode + (this.getFailedItems() == null ? 0 : this.getFailedItems().hashCode());
        return hashCode;
    }

    public DescribeAssessmentTargetsResult clone() {
        try {
            return (DescribeAssessmentTargetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

